---
title: Page Rule integration with APO · Cloudflare Automatic Platform
  Optimization docs
description: The following Page Rules can control APO. Any changes to caching
  via Page Rules require purging the cache for the changes to take effect.
lastUpdated: 2024-11-04T10:01:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/automatic-platform-optimization/reference/page-rule-integration/
  md: https://developers.cloudflare.com/automatic-platform-optimization/reference/page-rule-integration/index.md
---

The following Page Rules can control APO. Any changes to caching via Page Rules require purging the cache for the changes to take effect.

Warning

Consider using [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/) instead to control APO due to their enhanced configurability.

* **Cache Level: Bypass** — APO bypasses pages with response header `cf-apo-via: origin,page-rules`

* **Cache Level: Ignore Query String** — APO ignores all query strings when serving from Cache.

* **Cache Level: Cache Everything** — APO caches pages with all query strings.

  Warning

  Automatic page purge via the WordPress plugin won’t clean all cached pages, only pages without query strings. Cached responses will be returned even with request header `cache-control: no-cache`.

* **Bypass Cache on Cookie (Business and Enterprise plans only)** — APO applies custom bypass cookies in addition to the default list.

* **Edge Cache TTL** — APO applies custom Edge TTL instead of 30 days. This page rule is helpful for pages that can generate Captchas or nonces.

* **Browser Cache TTL** — APO applies custom Browser TTL.

* `CDN-Cache-Control` and `Cloudflare-CDN-Cache-Control` – Enables users to have detailed control over cache TTLs without using a page rule. For more information on the `CDN-Cache-Control` and `Cloudflare-CDN-Cache-Control` headers, refer to [CDN-Cache-Control](https://developers.cloudflare.com/cache/concepts/cache-control/).
