---
title: Access policies · Cloudflare Zero Trust docs
description: Cloudflare Access determines who can reach your application by
  applying the Access policies you configure.
lastUpdated: 2025-10-23T22:25:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/access-controls/policies/
  md: https://developers.cloudflare.com/cloudflare-one/access-controls/policies/index.md
---

Cloudflare Access determines who can reach your application by applying the Access policies you configure.

An Access policy consists of an **Action** as well as rules which determine the scope of the action. To build a rule, you need to choose a **Rule type**, **Selector**, and a **Value** for the selector.

* [Actions](#actions)
* [Rule types](#rule-types)
* [Selectors](#selectors)

## Actions

Actions let you grant or deny permission to a certain user or user group. You can set only one action per policy.

### Allow

The Allow action allows users that meet certain criteria to reach an application behind Access.

The following example lets any user with an `@example.com` email address, as validated against an IdP, reach the application:

| Action | Rule type | Selector | Value |
| - | - | - | - |
| Allow | Include | Emails Ending In: | `@example.com` |

You can add a Require rule in the same policy action to enforce additional checks. Finally, if the policy contains an Exclude rule, users meeting that definition are prevented from reaching the application.

For example, this second configuration lets any user from Portugal with a `@team.com` email address, as validated against an IdP, reach the application, except for `user-1` and `user-2`:

| Action | Rule type | Selector | Value |
| - | - | - | - |
| Allow | Include | Country | `Portugal` |
| | Require | Emails Ending In | `@team.com` |
| | Exclude | Email | `user-1@team.com`, `user-2@team.com` |

### Block

The Block action prevents users who meet certain critera from reaching an application behind Access. For example, the following policy blocks requests from Russian source IPs that are not on your [list of approved IPs](https://developers.cloudflare.com/cloudflare-one/traffic-policies/lists/).

| Action | Rule type | Selector | Value |
| - | - | - | - |
| Block | Include | Country | `Russian Federation` |
| | Exclude | IP list | `Corporate IP allowlist` |

Block policies are best used in conjunction with [Allow policies](#allow) as a way to carve out exceptions in those Allow policies. Since Access is deny by default, users who do not match a Block policy will still be denied access unless they explicitly match an Allow policy.

### Bypass

Warning

Bypass does not enforce any Access security controls and requests are not logged. Bypass policies should be tested before deploying to production. Consider using [Service Auth](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/#service-auth) if you would like to enforce policies and maintain logging without requiring user authentication.

As Bypass does not enforce Access security controls, Bypass policies do not support identity-based [rule types](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/#rule-types). When making Bypass policies, you will not be able to apply certain identity-based [selectors](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/#selectors) (such as email).

The Bypass action disables any Access enforcement for traffic that meets the defined rule criteria. Bypass is typically used to enable applications that require specific endpoints to be public.

For example, some applications have an endpoint under the `/admin` route that must be publicly routable. In this situation, you could create an Access application for the domain `test.example.com/admin/<your-url>` and add the following Bypass policy:

| Action | Rule type | Selector | Value |
| - | - | - | - |
| Bypass | Include | Everyone | `Everyone` |

As part of implementing a Zero Trust security model, Cloudflare does not recommend using Bypass to grant direct permanent access to your internal applications. To enable seamless and secure access for on-network employees, use Cloudflare Tunnel to [connect your private network](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/) and have users connect through WARP.

Note

When applying a Bypass action, security settings revert to the defaults configured for the zone and any configured Page Rules. If **Always use HTTPS** is enabled for the site, then traffic to the bypassed destination continues in HTTPS. If **Always use HTTPS** is disabled, traffic is HTTP.

### Service Auth

Service Auth rules enforce authentication flows that do not require an identity provider IdP login, such as service tokens and mutual TLS.

| Action | Rule type | Selector |
| - | - | - |
| Service Auth | Include | Valid certificate |

## Rule types

Rules work like logical operators. They help you define which categories of users your policy will affect. All Access policies must contain an Include rule. This is what defines the initial pool of eligible users who can access an application. You can then add Exclude and Require rules to enforce specific policies for those users.

### Include

The Include rule is similar to an OR logical operator. In case more than one Include rule is specified, users need to meet only one of the criteria.

### Exclude

The Exclude rule works like a NOT logical operator. A user meeting any Exclusion criteria will not be allowed access to the application.

### Require

The Require rule works like an AND logical operator. A user must meet all specified Require rules to be allowed access.

#### Require rules with OR operators

By default, any values added to a Require rule are concatenated by an AND operator. For example, let's say you want to grant access to an application to both the full-time employees and the contractors, and only the ones based in specific countries — say Portugal and the United States. If you set up a rule with the following configuration:

| Action | Rule type | Selector | Value |
| - | - | - | - |
| Allow | Require | Country | `United States`, `Portugal` |
| | Require | Emails ending in | `@cloudflare.com`, `@contractors.com` |

the policy will only grant access to people reaching the application from both the United States AND Portugal, and who have both an email ending in `@cloudflare.com` AND in `@contractors.com`. Therefore, nobody will have access to the application.

To require only one country and one email ending:

1. [Create a rule group](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/groups/) that includes users in Portugal OR in the United States:

   | Rule type | Selector | Value |
   | - | - | - |
   | Include | Country | `United States`, `Portugal` |

2. Create a policy that requires the rule group, and that also includes users with emails ending in either `@cloudflare.com` OR `@contractors.com`:

   | Action | Rule type | Selector | Value |
   | - | - | - | - |
   | Allow | Require | Rule group | `Country requirements` |
   | | Include | Emails ending in | `@cloudflare.com`, `@contractors.com` |

## Selectors

When you add a rule to your policy, you will be asked to specify the criteria/attributes you want users to meet. These attributes are available for all Access application types, including [SaaS](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/), [self-hosted](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/self-hosted-public-app/), and [non-HTTP](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/) applications.

Non-identity attributes are polled continuously, meaning they are-evaluated with each new HTTP request for changes during the [user session](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/session-management/). If you have configured [SCIM provisioning](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/scim/), you can force a user to re-attest all attributes with Access whenever you revoke the user in the IdP or update their IdP group membership.

| Selector | Description | Checked at login | Checked continuously1 | Identity-based selector? |
| - | - | - | - | - |
| Emails | `you@company.com` | ✅ | ❌ | ✅ |
| Emails ending in | `@company.com` | ✅ | ❌ | ✅ |
| External Evaluation | Allows or denies access based on [custom logic](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/external-evaluation/) in an external API. | ✅ | ❌ | ✅ |
| IP ranges | `192.168.100.1/24` (supports IPv4/IPv6 addresses and CIDR ranges) | ✅ | ✅ | ❌ |
| Country | Uses the IP address to determine country. | ✅ | ✅ | ❌ |
| Everyone | Allows, denies, or bypasses access to everyone. | ✅ | ❌ | ❌ |
| Common Name | The request will need to present a valid certificate with an expected common name. | ✅ | ✅ | ❌ |
| Valid Certificate | The request will need to present any valid client certificate. | ✅ | ✅ | ❌ |
| Service Token | The request will need to present the correct service token headers configured for the specific application. | ✅ | ✅ | ❌ |
| Any Access Service Token | The request will need to present the headers for any [service token](https://developers.cloudflare.com/cloudflare-one/identity/service-tokens/) created for this account. | ✅ | ✅ | ❌ |
| Login Methods | Checks the identity provider used at the time of login. | ✅ | ❌ | ✅ |
| Authentication Method | Checks the [multifactor authentication](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/mfa-requirements/) method used by the user, if supported by the identity provider. | ✅ | ❌ | ✅ |
| Identity provider group | Checks the user groups configured with your identity provider (IdP). This selector only displays if you use Microsoft Entra ID, GitHub, Google, Okta, or an IdP that provisions groups with [SCIM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/scim/). | ✅ | ❌ | ✅ |
| SAML Group | Checks a SAML attribute name / value pair. This selector only displays if you use a [generic SAML](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/) identity provider. | ✅ | ❌ | ✅ |
| OIDC Claim | Checks an OIDC claim name / value pair. This selector only displays if you use a [generic OIDC](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-oidc/) identity provider. | ✅ | ❌ | ✅ |
| Device posture | Checks [device posture signals](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/) from the WARP client or a third-party service provider. | ✅ | ✅ | ❌ |
| Warp | Checks that the device is connected to WARP, including the consumer version. | ✅ | ✅ | ❌ |
| Gateway | Checks that the device is connected to your Zero Trust instance through the [WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/). | ✅ | ✅ | ❌ |

1 For SaaS applications, Access can only enforce policies at the time of initial sign on and when reissuing the SaaS session. Once the user has authenticated to the SaaS app, session management falls solely within the purview of the SaaS app.

## Order of execution

Policies are evaluated based on their action type and ordering. Bypass and Service Auth policies are evaluated first, from top to bottom as shown in the UI. Then, Block and Allow policies are evaluated based on their order.

For example, if you have a list of policies arranged as follows:

* Allow A
* Block B
* Service Auth C
* Bypass D
* Allow E

The policies will execute in this order: Service Auth C > Bypass D > Allow A > Block B > Allow E. Once a user matches an Allow or Block policy, evaluation stops and no subsequent policies can override the decision.

## Common misconfigurations

If you add any of the following rules to an Allow policy, anyone will be able to access your application.

### Include everyone

| Rule type | Selector | Value |
| - | - | - |
| Include | Everyone | `Everyone` |

### Include all valid emails

| Rule type | Selector | Value |
| - | - | - |
| Include | Login Methods | `One-time PIN` |

## Additional resources

* [API and Terraform](https://developers.cloudflare.com/cloudflare-one/api-terraform/) provide programmatic ways to manage your Access policies and configurations.
