---
title: Temporary authentication · Cloudflare Zero Trust docs
description: With Cloudflare Access, you can require that users obtain approval
  before they can access a specific self-hosted application or SaaS application.
  The administrator will receive an email notification to approve or deny the
  request. Unlike a typical Allow policy, the user will have to request access
  at the end of each session. This allows you to define the users who should
  have persistent access and those who must request temporary access.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/access-controls/policies/temporary-auth/
  md: https://developers.cloudflare.com/cloudflare-one/access-controls/policies/temporary-auth/index.md
---

With Cloudflare Access, you can require that users obtain approval before they can access a specific self-hosted application or SaaS application. The administrator will receive an email notification to approve or deny the request. Unlike a typical Allow policy, the user will have to request access at the end of each session. This allows you to define the users who should have persistent access and those who must request temporary access.

## Set up temporary authentication

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Access** > **Applications**.

2. Choose a **Self-hosted** or **SaaS** application and select **Configure**.

3. Choose an **Allow** policy and select **Configure**.

4. Under **Additional settings**, turn on [**Purpose justification**](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/require-purpose-justification/).

5. Turn on **Temporary authentication**.

6. Enter the **Email addresses of the approvers**.

   Note

   Your approvers must be authenticated by Access. If they do not have an active session, Access will verify their identity against your [App Launcher Access policy](https://developers.cloudflare.com/cloudflare-one/applications/app-launcher/).

7. Save the policy.

Temporary authentication is now enabled for users who match this policy. You can optionally add a second **Allow** policy for users who should have persistent access. Be sure the policy order is set to allow persistent users through.

## Temporary authentication requests

![Temporary authentication request page shown to users](https://developers.cloudflare.com/_astro/temp-auth-request.WnwXx8ul_GCVA5.webp)

Approvers will receive a request similar to the example below. The approver can then grant access for a set amount of time, up to a maximum of 24 hours.

![Temporary authentication approval page shown to administrators](https://developers.cloudflare.com/_astro/temp-auth-approval.D0-hjStz_1NNzm1.webp)
