---
title: Access API examples · Cloudflare Zero Trust docs
description: "You can use the Cloudflare Access API to create policies,
  including individual rule blocks inside of group or policy bodies. For
  example, this policy allows all Cloudflare email account users to reach the
  application with the exception of one account:"
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/
  md: https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/index.md
---

You can use the Cloudflare Access API to create policies, including individual rule blocks inside of group or policy bodies. For example, this policy allows all Cloudflare email account users to reach the application with the exception of one account:

```json
{
  "name": "allow cloudflare employees",
  "decision": "allow",
  "include": [
    {
      "email_domain": {
        "domain": "cloudflare.com"
      }
    }
  ],
  "exclude": [
    {
      "email": {
        "email": "notthisperson@cloudflare.com"
      }
    }
  ],
  "require": []
}
```

## Example rule configurations

[Rule group](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/access-group/)

[Use a pre-existing rule group.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/access-group/)

[Authentication method](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/authentication-method/)

[Allow access based on the "amr" identifier.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/authentication-method/)

[Any valid service token](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/any-service-token/)

[The request will need to present the headers for any service token created for this account.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/any-service-token/)

[Common name](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/common-name/)

[The request will need to present a valid certificate with an expected common name.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/common-name/)

[Country Code](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/country-code/)

[Allow a specific country.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/country-code/)

[Email domain](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/email-domain/)

[Allow an entire email domain.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/email-domain/)

[Email](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/email/)

[Allow a specific email address.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/email/)

[Microsoft Entra Group](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/entra-group/)

[Allow members of a Microsoft Entra group. The ID is the group UUID (\`id\`) in Microsoft Entra ID.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/entra-group/)

[Everyone](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/everyone/)

[Allow anyone to log in.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/everyone/)

[GitHub™ Organization](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/github-org/)

[Allow members of a specific GitHub organization.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/github-org/)

[G Suite Group](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/gsuite-group/)

[Allow members of a specific G Suite group.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/gsuite-group/)

[Access API examples](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/)

[IP range](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/ip-range/)

[Allow an IP range.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/ip-range/)

[mTLS certificate](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/mtls-certificate/)

[The request will need to present a valid certificate.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/mtls-certificate/)

[Okta Group](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/okta-group/)

[Allow members of an Okta Group.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/okta-group/)

[SAML Attribute](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/saml-attribute/)

[Allow users with specific SAML attributes.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/saml-attribute/)

[Service token](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/service-token/)

[The request will need to present the correct service token headers.](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/service-token/)
