---
title: Application Library · Cloudflare Zero Trust docs
description: "The Application Library allows users to manage their SaaS
  applications in Cloudflare Zero Trust by consolidating views across all
  relevant products: Gateway, Access, and Cloud Access Security Broker (CASB).
  The App Library provides visibility and control for available applications, as
  well as the ability to view categorized hostnames and manage configuration for
  Access for SaaS and Gateway policies. For example, you can use the App Library
  to review how Gateway uses specific hostnames to match against application
  traffic."
lastUpdated: 2025-10-23T20:06:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/applications/app-library/
  md: https://developers.cloudflare.com/cloudflare-one/applications/app-library/index.md
---

The Application Library allows users to manage their SaaS applications in Cloudflare Zero Trust by consolidating views across all relevant products: [Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/), [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/), and [Cloud Access Security Broker (CASB)](https://developers.cloudflare.com/cloudflare-one/applications/casb/). The App Library provides visibility and control for available applications, as well as the ability to view categorized hostnames and manage configuration for Access for SaaS and Gateway policies. For example, you can use the App Library to review how Gateway uses specific hostnames to match against application traffic.

To access the App Library in [Zero Trust](https://one.dash.cloudflare.com/), go to **My team** > **App Library**. Each application card will list the number of hostnames associated with the application, the supported Zero Trust product usage, and the [app type](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/#app-types).

The App Library groups [Do Not Inspect applications](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/#do-not-inspect-applications) within the corresponding application. For example, the App Library will group *Google Drive (Do Not Inspect)* under **Google Drive**. Traffic that does not match a known application will not be included in the App Library.

## View application details

Select an application card to view details about the application.

### Overview

The **Overview** tab shows details about an application, including:

* Name
* Shadow IT [review status](#review-applications)
* Number of hostnames
* [App type](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/#app-types)
* Supported Zero Trust applications
* Application ID for use with the API and Terraform

### Findings

The **Findings** tab shows any connected [CASB integrations](https://developers.cloudflare.com/cloudflare-one/applications/casb/#manage-casb-integrations) for the selected application, as well as instances of any detected [posture findings](https://developers.cloudflare.com/cloudflare-one/applications/casb/manage-findings/#posture-findings) and [content findings](https://developers.cloudflare.com/cloudflare-one/applications/casb/manage-findings/#content-findings) for each integration.

### Policies

The **Policies** tab shows any [Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) and [Access for SaaS](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/) policies related to the selected application.

### Usage

The **Usage** tab shows any logs for [Gateway traffic requests](https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/), [Access authentication events](https://developers.cloudflare.com/cloudflare-one/insights/logs/audit-logs/#authentication-logs), [Shadow IT Discovery user sessions](https://developers.cloudflare.com/cloudflare-one/insights/analytics/shadow-it-discovery/), and [generative AI prompt logs](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#view-prompt-logs) sent to the selected application. This section requires logs to be turned on for each feature.

The Shadow IT Discovery dashboard will provide more details for discovered applications. To access Shadow IT Discovery in [Zero Trust](https://one.dash.cloudflare.com/), go to **Analytics**, then select **Shadow IT Discovery**.

## Review applications

The App Library synchronizes application review statuses with approval statuses from the [Shadow IT Discovery SaaS analytics](https://developers.cloudflare.com/cloudflare-one/insights/analytics/shadow-it-discovery/) dashboard.

To organize applications into their approval status for your organization, you can mark them as **Unreviewed** (default), **In review**, **Approved**, and **Unapproved**.

| Status | API value | Description |
| - | - | - |
| Approved | `approved` | Applications that have been marked as sanctioned by your organization. |
| Unapproved | `unapproved` | Applications that have been marked as unsanctioned by your organization. |
| In review | `in review` | Applications in the process of being reviewed by your organization. |
| Unreviewed | `unreviewed` | Unknown applications that are neither sanctioned nor being reviewed by your organization at this time. |

To set the status of an application:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **My team** > **App Library**.
2. Locate the card for the application.
3. In the three-dot menu, select the option to mark your desired status.

Once you mark the status of an application, its badge will change. You can filter applications by their status to review each application in the list for your organization. The review status for an application in the App Library and Shadow IT Discovery will update within one hour.

Note

Approval status does not impact a user's ability to access an application. Users are allowed or blocked according to your [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) and [Gateway policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/). To filter traffic based on approval status, use the [*Application Status*](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#application-approval-status) selector.

## Application confidence scorecards

Application confidence scorecards provide automated risk assessment for AI and SaaS applications to help organizations make informed decisions about application approval and security policies. These scores bring scale and automation to the labor- and time-intensive task of evaluating generative AI and SaaS applications.

The scoring system evaluates applications across multiple security, compliance, and operational dimensions to generate two complementary scores: the Application Posture Score and the Generative AI Posture Score. These scores help security teams identify risks in Shadow AI and Shadow IT deployments without manual auditing of every application.

To view an application's confidence scorecard:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **My team** > **App Library**
2. Find the application you would like to review or search it by name.
3. Review the Application Posture Score and the Generative AI Posture Score which are generated on the application card.

### Scoring methodology

#### Application Posture Score (5 points)

The Application Posture Score evaluates SaaS providers across five major categories.

| Category | Points | Assessment Criteria | Scoring Logic |
| - | - | - | - |
| Security and Privacy Compliance | 1.2 | Presence of SOC 2 and ISO 27001 certifications, which signal operational maturity and adherence to security frameworks. | Full credit awarded for both certifications; partial credit for one certification; no credit if neither certification is present. |
| Data Management Practices | 1.0 | Data retention windows and whether the provider shares data with third parties. | Shorter retention periods and no third-party data sharing earn the highest marks. Applications with indefinite data retention or extensive data sharing receive lower scores. |
| Security Controls | 1.0 | Support for Multi-Factor Authentication (MFA), Single Sign-On (SSO), TLS 1.3, role-based access controls, and session monitoring capabilities. | These represent table stakes of modern SaaS security. Full credit requires comprehensive support across all controls; partial credit awarded for subset implementation. |
| Security Reports and Incident History | 1.0 | Availability of trust or security pages, active bug bounty programs, incident response transparency, and recent breach history. | Recent material breaches result in full point deduction. Proactive security measures like bug bounty programs and transparent incident reporting increase scores. |
| Financial Stability | 0.8 | Company financial status, funding levels, and operational stability. | Public companies and heavily capitalized providers score highest, while startups with limited funding or companies in financial distress receive lower scores. |
| Total Points | 5.0 | | |

#### Generative AI Posture Score (5 points)

| Category | Points | Assessment Criteria | Scoring Logic |
| - | - | - | - |
| Compliance | 1.0 | Presence of ISO 42001 certification for AI management systems. | Full credit for ISO 42001 certification; no credit without this specialized AI governance certification. |
| Deployment Security Model | 1.0 | Whether application access requires authentication and implements rate limiting, or if services are publicly exposed without controls. | Authenticated access with proper rate limiting receives full credit; publicly exposed services without controls receive minimal scoring. |
| System Card | 1.0 | Publication of model or system cards documenting safety evaluations, bias testing, and risk assessments. | Comprehensive system cards with detailed safety and bias documentation receive full credit; incomplete or missing documentation results in score reduction. |
| Training Data Governance | 2.0 | Whether user data is explicitly excluded from model training and availability of opt-in/opt-out controls for training data usage. | Explicit exclusion of user data from training receives maximum points; opt-in/opt-out controls receive partial credit; no controls or guaranteed user data training receives minimal scoring. |
| **Total Points** | **5.0** | | |

### Automated scoring infrastructure

#### Web crawling and data extraction

The scoring system employs automated infrastructure to crawl and analyze public information sources.

* Data sources: Trust centers, privacy policies, security pages, compliance documents, and vendor documentation.
* Extraction process: Large language models parse documents to identify relevant information, with structured extraction methods to resist hallucinations and ensure accuracy.
* Validation requirements: Source validation and structured data extraction prevent false positives and ensure reliable scoring.

#### Human oversight and quality assurance

Automated results are supplemented with manual review to maintain transparency and ensure data integrity.

* Review process: Every automated score undergoes review and audit by Cloudflare analysts before publication in the Application Library.
* Validation methodology: Combination of automated crawling and extraction with human validation ensures comprehensive and trustworthy scoring.
* Update frequency: Scores update dynamically as vendors improve security and compliance postures, providing live assessment rather than static reports.

#### Report score inaccuracies

If you believe one of the Application confidence scores is incorrect or have additional evidence that should be considered in the scoring process, contact `app-confidence-scores@cloudflare.com`. Include relevant documentation or evidence that supports your assessment to help us review and update the score accordingly.
