---
title: Detection entries · Cloudflare Zero Trust docs
description: Cloudflare DLP can scan your web traffic and SaaS applications for
  specific data defined in custom detection entries. Detection entries allow you
  to define custom data patterns for DLP to detect using DLP profiles. Detection
  entries include custom datasets with defined data, document entries with
  example fingerprints, and AI prompt topics.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/
  md: https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/index.md
---

Cloudflare DLP can scan your web traffic and SaaS applications for specific data defined in custom detection entries. Detection entries allow you to define custom data patterns for DLP to detect using [DLP profiles](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/). Detection entries include custom [datasets](#datasets) with defined data, [document entries](#documents) with example fingerprints, and [AI prompt topics](#ai-prompt-topics).

You can configure sensitive data to be hashed before reaching Cloudflare and redacted from matches in [payload logs](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#log-the-payload-of-matched-rules).

## Datasets

You can create and upload custom datasets to scan for specific matching data.

### Dataset types

#### Exact Data Match

Exact Data Match (EDM) protects sensitive information, such as names, addresses, phone numbers, and credit card numbers.

All data in uploaded EDM datasets is encrypted before reaching Cloudflare. To detect matches, Cloudflare hashes traffic and compares it to hashes from your dataset. Matched data will be redacted in payload logs.

#### Custom Wordlist

Custom Wordlist (CWL) protects non-sensitive data, such as intellectual property and SKU numbers. Optionally, CWL can detect case-sensitive data.

Cloudflare stores data from CWL datasets within DLP. Plaintext matches appear in payload logs.

### Prepare DLP datasets

#### Formatting

To prepare a dataset for DLP, add your desired data to a multi-column spreadsheet. Each line must be at least six characters long. Entries do not require trailing or final commas.

For compatibility, save your file in either `.csv` or `.txt` format with LF (`\n`) newline characters. DLP does not support CRLF (`\r\n`) newline characters. For information on dataset limits, refer to [Account limits](https://developers.cloudflare.com/cloudflare-one/account-limits/#data-loss-prevention-dlp).

#### Column title cells

Column title cells may result in false positives in Custom Wordlist datasets and should be removed.

DLP will detect and use title cells as column names for Exact Data Match datasets. If multiple columns have the same name, DLP will append a number sign (`#`) and number to their names.

Update EDM datasets

To select which Exact Data Match columns to use, you will need to [reupload any EDM datasets](#manage-existing-datasets) added prior to column support.

### Upload a new dataset

Upload an Exact Data Match dataset

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Data loss prevention** > **Detection entries**.
2. Go to **Datasets**.
3. Select **Add a dataset**. In **Exact Data Match (EDM)**, choose **Select**.
4. Upload your dataset file. Select **Next**.
5. Review and choose the detected columns you want to include. Select **Next**.
6. Name your dataset. Optionally, add a description. Select **Next**.
7. Review the details for your uploaded dataset. Select **Save dataset**.

DLP will encrypt your dataset and save its hash.

Upload a Custom Wordlist dataset

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Data loss prevention** > **Detection entries**.
2. Go to **Datasets**.
3. Select **Add a dataset**. In **Custom Wordlist (CWL)**, choose **Select**.
4. Name your dataset. Optionally, add a description.
5. (Optional) In **Settings**, turn on **Enforce case sensitivity** to require matched values to contain exact capitalization.
6. In **Upload file**, choose your dataset file.
7. Select **Save**.

DLP will save your dataset in cleartext.

The dataset will appear in the list with an **Uploading** status. Once the upload is complete, the status will change to **Complete**. To use your uploaded dataset, add it as an existing entry to a [custom DLP profile](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/#build-a-custom-profile).

### Manage existing datasets

Uploaded DLP datasets are read-only. To update a dataset, you must upload a new file to replace the original.

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Data loss prevention** > **DLP datasets**.
2. Select the dataset you want to update.
3. Select **Upload dataset** and choose your updated dataset. Select **Next**.
4. If your select dataset is an Exact Data Match dataset, review and choose the new columns. Select **Next**.
5. Select **Save dataset**.

Your new dataset will replace the original dataset.

Remove existing column entries

If you want to update an Exact Data Match dataset to remove a column in use as an [existing detection entry](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/#build-a-custom-profile), you must remove the existing entry from any custom DLP profiles using it before updating the dataset.

## Documents

You can upload example documents to scan for unstructured data or specific document types common to your organization. DLP will create a unique fingerprint of the document and detect patterns in your organization's traffic based on how similar it is to the original fingerprint.

DLP stores uploaded documents encrypted at rest in a [Cloudflare R2](https://developers.cloudflare.com/r2/) bucket. To upload sensitive data that is only stored in memory, use [Exact Data Match](#exact-data-match).

### Prepare document entries

DLP supports documents in `.docx` and `.txt` format. Documents must be under 10 MB.

### Upload a new document entry

To upload a new document entry to DLP:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Data loss prevention** > **Detection entries**.
2. Go to **Documents**.
3. Select **Add a document entry**.
4. Name your document. Optionally, add a description.
5. In **Minimum similarity for matches**, enter a value between 0% and 100%.
6. In **Upload document**, choose and upload your document file.
7. Select **Save**.

The document will appear in the list with a **Pending** status. Once the upload is complete, the status will change to **Complete**. If you created a document entry with Terraform, the status will be **No file** until you upload a file.

To use your uploaded document fingerprint, add it as an existing entry to a [custom DLP profile](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/#build-a-custom-profile).

### Manage existing document entries

Uploaded document entries are read-only. To update a document entry, you must upload a new file to replace the original.

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Data loss prevention** > **Detection entries**.
2. Choose the document you want to update and select **Edit**.
3. (Optional) Update the name and minimum similarity for matches for your document entry. You can also open the existing uploaded document.
4. In **Update document entry**, choose and upload your updated document file.
5. Select **Save**.

Your new document entry will replace the original document entry. If your file upload fails, DLP will still use the original document fingerprint to scan traffic until you delete the entry.

## AI prompt topics

DLP uses [Application Granular Controls](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#application-granular-controls) to detect and categorize prompts submitted to generative AI tools. Application Granular Controls analyzes prompts for both content and user intent. Supported AI prompt protection detections include:

| Detection entry | Description |
| - | - |
| Content: PII | Prompt contains personal information such as names, SSNs, or email addresses. |
| Content: Credentials and Secrets | Prompt contains API keys, passwords, or other sensitive credentials. |
| Content: Source Code | Prompt contains actual source code, code snippets, or proprietary algorithms. |
| Content: Customer Data | Prompt contains customer names, projects, business activities, or confidential customer contexts. |
| Content: Financial Information | Prompt contains financial numbers or confidential business data. |
| Intent: PII | Prompt requests specific personal information about individuals. |
| Intent: Code Abuse and Malicious Code | Prompt requests malicious code for attacks, exploits, or harmful activities. |
| Intent: Jailbreak | Prompt attempts to circumvent AI security policies. |

Each detection entry is categorized as either Content or Intent. Content focuses on the specific text or data the user provides the generative AI tool. It is the information the AI needs to process and analyze to generate a response. Intent focuses on the user's goal or objective for the AI's response. It dictates the type of output the user wants to receive. This category is particularly useful for customers who are using SaaS connectors or MCPs that provide the AI application access to internal data sources that contain sensitive information.

To use an AI prompt topic, configure the corresponding [predefined DLP profile](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/predefined-profiles/#ai-prompt) or add it as an existing entry to a [custom DLP profile](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/#build-a-custom-profile). AI prompt protection is available for ChatGPT, Google Gemini, Perplexity, and Claude.
