---
title: Deliver emails to the junk email folder - Microsoft 365 · Cloudflare Zero
  Trust docs
description: In this tutorial, you will learn to deliver BULK messages to the
  user's junk email folder, and MALICIOUS, SPAM, and SPOOF messages to the
  Administrative Quarantine (this requires an administrator to release the
  emails).
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/prerequisites/m365-email-security-mx/use-cases/five-junk-admin-quarantine/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/prerequisites/m365-email-security-mx/use-cases/five-junk-admin-quarantine/index.md
---

In this tutorial, you will learn to deliver `BULK` messages to the user's junk email folder, and `MALICIOUS`, `SPAM`, and `SPOOF` messages to the Administrative Quarantine (this requires an administrator to release the emails).

## Configure anti-spam policies

To configure anti-spam policies:

1. Open the [Microsoft 365 Defender console](https://security.microsoft.com/).

2. Go to **Email & collaboration** > **Policies & rules**.

3. Select **Threat policies**.

4. Under **Policies**, select **Anti-spam**.

5. Select the **Anti-spam inbound policy (Default)** text (not the checkbox).

6. In **Actions**, scroll down and select **Edit actions**.

7. Set the following conditions and actions (you might need to scroll up or down to find them):

* **Spam**: *Move messages to Junk Email folder*.
* **High confidence spam**: *Quarantine message*.
  * **Select quarantine policy**: \_AdminOnlyAccessPolicy\_.
* **Phishing**: *Quarantine message*.
  * **Select quarantine policy**: \_AdminOnlyAccessPolicy\_.
* **High confidence phishing**: *Quarantine message*.
  * **Select quarantine policy**: \_AdminOnlyAccessPolicy\_.
* **Retain spam in quarantine for this many days**: Default is 15 days. Email Security recommends 15-30 days.
  * Select the spam actions in the above step.

1. Select **Save**.

## Create transport rules

To create the transport rules that will send emails with certain [disposition](https://developers.cloudflare.com/cloudflare-one/email-security/reference/dispositions-and-attributes/#dispositions) to Email Security:

1. Open the new [Exchange admin center](https://admin.exchange.microsoft.com/#/homepage).

2. Go to **Mail flow** > **Rules**.

3. Select **Add a Rule** > **Create a new rule**.

4. Set the following rule conditions:

   * **Name**: *Email Security Deliver to Junk Email folder\`*.

   * **Apply this rule if**: *The message headers* > *includes any of these words*.

     * **Enter text**: `X-CFEmailSecurity-Disposition` > **Save**.
     * **Enter words**: `BULK` > **Add** > **Save**.

   * **Apply this rule if**: Select **+** to add a second condition.

   * **And**: *The sender* > *IP address is in any of these ranges or exactly matches* > enter the egress IPs in the [Egress IPs](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/egress-ips/) page.

   * **Do the following** - *\_Modify the message properties\_ > \_Set the Spam Confidence Level (SCL)\_ > \_5\_*.

5. Select **Next**.

6. You can use the default values on this screen. Select **Next**.

7. Review your settings and select **Finish** > **Done**.

8. Select the rule Email Security Deliver to Junk Email folder\` you have just created, and **Enable**.

9. Select **Add a Rule** > **Create a new rule**.

10. Set the following rule conditions:

    * **Name**: *\`Email Security Admin Managed Host Quarantine\`*.

    * **Apply this rule if**: *The message headers* > *includes any of these words*.

      * **Enter text**: `X-CFEmailSecurity-Disposition` > **Save**.
      * **Enter words**: *\`MALICIOUS\`, \`UCE\`, \`SPOOF\`* > **Add** > **Save**.

    * **Apply this rule if**: Select **+** to add a second condition.

    * **And**: *The sender* > *IP address is in any of these ranges or exactly matches* > enter the egress IPs in the [Egress IPs](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/egress-ips/) page.

    * **Do the following**: *\_Redirect the message to\_ > \_hosted quarantine\_*.

11. Select **Next**.

12. You can use the default values on this screen. Select **Next**.

13. Review your settings and select **Finish** > **Done**.

14. Select the rule *\`Email Security Admin Managed Host Quarantine\`* you have just created, and select **Enable**.
