---
title: Data security analytics · Cloudflare Zero Trust docs
description: The Data security analytics dashboard reports security issues and
  sensitive data found within your SaaS applications, cloud environments, and
  HTTP traffic. It visualizes event data collected from your DLP and CASB
  policies. If neither DLP nor CASB is enabled in your account, the dashboard
  appears empty.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/analytics/data-analytics/
  md: https://developers.cloudflare.com/cloudflare-one/insights/analytics/data-analytics/index.md
---

The Data security analytics dashboard reports security issues and sensitive data found within your SaaS applications, cloud environments, and HTTP traffic. It visualizes event data collected from your DLP and CASB policies. If neither DLP nor CASB is enabled in your account, the dashboard appears empty.

To view the Data security analytics dashboard:

1. Log into [Zero Trust](https://one.dash.cloudflare.com).
2. Go to **Analytics** > **Dashboards**.
3. Select **Data security analytics**.

## Prerequisites

To populate this dashboard, you must have:

* [Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/) configured to generate event data from scanned web traffic or SaaS applications.
* At least one [Cloud Access Security Broker (CASB)](https://developers.cloudflare.com/cloudflare-one/applications/casb/) integration connected to capture findings from your SaaS applications or cloud environments.

## Available insights

The dashboard includes the following panels and metrics:

* [SaaS and Cloud findings by count](https://developers.cloudflare.com/cloudflare-one/insights/analytics/data-analytics/#saas-and-cloud-findings-by-count)
* [Posture findings by Severity](https://developers.cloudflare.com/cloudflare-one/insights/analytics/data-analytics/#posture-findings-by-severity)
* [DLP matches in HTTP requests over time](https://developers.cloudflare.com/cloudflare-one/insights/analytics/data-analytics/#dlp-matches-in-http-requests-over-time)
* Top integrations by posture findings
* Top integrations by content findings
* Top cloud resources by findings
* Top users by DLP policies triggered

### SaaS and Cloud findings by count

The SaaS and Cloud findings by count chart shows a time series view of Posture and Content findings. [Posture](https://developers.cloudflare.com/cloudflare-one/applications/casb/manage-findings/#posture-findings) denotes posture findings which include misconfigurations, unauthorized user activity, and other data security issues. [Content](https://developers.cloudflare.com/cloudflare-one/applications/casb/manage-findings/#content-findings) denotes content findings which include instances of potential data exposure as identified by [DLP](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/).

Each bar represents the total number of findings detected within a given time interval. You can use this view to observe patterns or spikes in findings over time. Hover over any bar to view the exact count of Posture and Content findings for that period.

To review findings in detail, log into [Zero Trust](https://one.dash.cloudflare.com) and go to **CASB** > **Posture Findings** or **Content Findings**.

### Posture findings by Severity

The Posture findings by severity chart displays the distribution of CASB findings based on their [severity levels](https://developers.cloudflare.com/cloudflare-one/applications/casb/manage-findings/#severity-levels). Each segment of the circle represents the number of posture issues classified as `Critical`, `High`, `Medium`, or `Low`.

To review findings in detail, log into [Zero Trust](https://one.dash.cloudflare.com) and go to **CASB** > **Posture Findings**.

### DLP matches in HTTP requests over time

The DLP matches in HTTP requests over time chart displays when [DLP policies](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/) were triggered by users over a specified period of time.

Unlike the SaaS and Cloud findings by count chart above, which relies on CASB findings from data at rest, the DLP matches in HTTP requests over time chart reflects DLP detections in HTTP traffic — helping you monitor sensitive data movement in real time.

To review DLP detections in detail, log into [Zero Trust](https://one.dash.cloudflare.com) and go to **Logs** > **Gateway** > **HTTP**. Use the **DLP profiles** or **DLP match data** filters to view HTTP requests that triggered a DLP policy.
