---
title: User logs · Cloudflare Zero Trust docs
description: User logs show a list of all users who have authenticated to
  Cloudflare Zero Trust. For each user who has logged in, you can view their
  enrolled devices, login history, seat usage, and identity used for policy
  enforcement.
lastUpdated: 2025-10-23T20:06:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/logs/users/
  md: https://developers.cloudflare.com/cloudflare-one/insights/logs/users/index.md
---

User logs show a list of all users who have authenticated to Cloudflare Zero Trust. For each user who has logged in, you can view their enrolled devices, login history, seat usage, and identity used for policy enforcement.

## View user logs

In [Zero Trust](https://one.dash.cloudflare.com/), go to **My Team** > **Users**. This page lists all users who have registered the WARP client or authenticated to a Cloudflare Access application. You can select a user's name to view detailed logs, [revoke their session](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/session-management/#revoke-user-sessions), or [remove their seat](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/seat-management/).

### Available logs

* **User Registry identity**: Select the user's name to view their last seen identity. This identity is used to evaluate Gateway policies and WARP [device profiles](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/). A refresh occurs when the user re-authenticates WARP, logs into an Access application, or has their IdP group membership updated via [SCIM provisioning](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/scim/). To track how the user's identity has changed over time, go to the **Audit logs** tab.
* **Session identities**: The user's active sessions, the identity used to authenticate each session, and when each session will [expire](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/session-management/).
* **Devices**: Devices registered to the user via WARP.
* **Recent activities**: The user's five most recent Access login attempts. For more details, refer to your [authentication audit logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/audit-logs/#authentication-audit-logs).
