---
title: Tips and best practices · Cloudflare Zero Trust docs
description: When setting up WARP Connector on a virtual private cloud (VPC),
  you may need to configure additional settings in the cloud service provider.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/tips/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/tips/index.md
---

## VPC deployments

When setting up WARP Connector on a virtual private cloud (VPC), you may need to configure additional settings in the cloud service provider.

### GCP

For Google Cloud Project (GCP) deployments, [enable IP forwarding](https://cloud.google.com/vpc/docs/using-routes#canipforward) on the VM instance where you installed WARP Connector.

### AWS

For Amazon Web Services (AWS) deployments:

* Stop [source/destination checking](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html) on the EC2 instance where you installed WARP Connector.

* In your [subnet route table](https://docs.aws.amazon.com/vpc/latest/userguide/subnet-route-tables.html), route all IPv4 traffic to the EC2 instance where you installed WARP Connector. For example:

  | Destination | Target |
  | - | - |
  | `0.0.0.0/0` | `eni-11223344556677889` |

## WARP Connector with cloudflared

WARP Connector and [`cloudflared`](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/) can run together on the same Linux host. This configuration is useful when you want to use WARP Connector as a gateway for your private network, while also using the `cloudflared` daemon to expose specific applications.

By design, WARP Connector captures all outbound traffic and routes it through Cloudflare's network. This prevents `cloudflared` from making its own [required outbound connections](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/tunnel-with-firewall/#required-for-tunnel-operation) to Cloudflare, causing the tunnel to fail with connection timeouts.

To allow `cloudflared` to connect, use [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/) to explicitly exclude the [Cloudflare Tunnel destinations](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/tunnel-with-firewall/) from the WARP tunnel. For example, if you are using Split Tunnels in **Exclude** mode, add the following hostnames (or their corresponding IP ranges) to your Split Tunnel exclusion list:

* `region1.v2.argotunnel.com`
* `region2.v2.argotunnel.com`

Note

Split Tunnels is the only supported method of running both connectors on one machine. Due to its low-level integration with the kernel networking stack, WARP Connector will override any routing configurations made by commands such as `ip route add` and `iptables`.
