---
title: Device UUID · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust allows you to build Zero Trust rules based on
  device UUIDs supplied in an MDM file. You can create these rules so that
  access to applications is granted only to users connecting from company
  devices.
lastUpdated: 2025-10-23T22:25:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/device-uuid/
  md: https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/device-uuid/index.md
---

Cloudflare Zero Trust allows you to build Zero Trust rules based on device UUIDs supplied in an MDM file. You can create these rules so that access to applications is granted only to users connecting from company devices.

## Prerequisites

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [WARP Client Checks](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/).

## 1. Assign UUIDs to devices

You will need to use a [managed deployment tool](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/) to assign UUIDs. It is not possible to assign them manually.

1. Generate a unique identifier for each corporate device. For best practices on choosing UUIDs, refer to the [Android documentation](https://developer.android.com/training/articles/user-data-ids#best-practices-android-identifiers).

2. Enter the UUIDs into your MDM configuration file using the [`unique_client_id` key](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#unique_client_id).

## 2. Create a list of UUIDs

To create rules based on device UUIDs, you first need to create a [Gateway List](https://developers.cloudflare.com/cloudflare-one/traffic-policies/lists/) of UUIDs.

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **My Team** > **Lists**.

2. Select **Create manual list** or **Upload CSV**. For larger teams, we recommend uploading a CSV or using Cloudflare's [API endpoint](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/lists/methods/list/).

3. Give your list a descriptive name, as this name will appear when configuring your policies.

4. Set **List Type** to *Device IDs*.

5. Enter the UUIDs of the devices your team manages, or upload your CSV file.

6. Select **Save**.

Note

Hyphens are automatically stripped from UUIDs. For example, the posture check will match `123e4567-e89b-12d3-a456-426614174000` to `123e4567e89b12d3a456426614174000`.

## 3. Enable the posture check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.

2. Scroll down to **WARP client checks** and select **Add new**.

3. Select **Unique Client ID**.

4. You will be prompted for the following information:

   * **Name**: Enter a unique name for this device posture check.
   * **Operating system**: Select the operating system of the device.
   * **List**: Select your [list of UUIDs](#2-create-a-list-of-uuids).

5. Select **Save**.

6. [Verify](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/#2-verify-device-posture-checks) that the posture check is returning the expected results.

You can now create an Access or Gateway device posture policy that checks if the device presents a UUID on your list.
