---
title: Firewall · Cloudflare Zero Trust docs
description: The Firewall device posture attribute ensures that a firewall is
  running on a device.
lastUpdated: 2025-10-23T22:25:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/firewall/
  md: https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/firewall/index.md
---

The Firewall device posture attribute ensures that a firewall is running on a device.

## Prerequisites

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [WARP Client Checks](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/).

## Enable the firewall check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.
2. Scroll down to **WARP client checks** and select **Add new**.
3. Select **Firewall**.
4. Enter a descriptive name for the check.
5. Select your operating system.
6. Turn on **Enable firewall check**.
7. Select **Save**.

Next, go to **Logs** > **Posture** and verify that the firewall check is returning the expected results.

## How WARP checks the firewall status

Operating systems determine firewall configuration in various ways. Follow the steps below to understand how the WARP client determines if the firewall is enabled.

### On macOS

macOS has two firewalls: an application-based firewall and a port-based firewall. The WARP client will report a firewall is enabled if either firewall is running.

#### Application-based firewall

1. Open **System Settings** and go to **Network**.
2. Verify that **Firewall** is `Active`.

#### Port-based firewall

1. Open Terminal and run:

   ```sh
   sudo /sbin/pfctl -s info
   ```

2. Verify that **Status** is `Enabled`.

### On Windows

1. Open PowerShell and run:

   ```powershell
   Get-NetFirewallProfile -PolicyStore ActiveStore -Name Public
   ```

2. Verify that **Enabled** is `True`.
