---
title: DNS resolver IPs and hostnames · Cloudflare Zero Trust docs
description: When you create a DNS location, Gateway assigns IPv4/IPv6 addresses
  and DoT/DoH hostnames to that location. These are the IP addresses and
  hostnames you send your DNS queries to for Gateway to resolve.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/dns-resolver-ips/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/dns-resolver-ips/index.md
---

When you create a DNS location, Gateway assigns IPv4/IPv6 addresses and DoT/DoH hostnames to that location. These are the IP addresses and hostnames you send your DNS queries to for Gateway to resolve.

To view the resolver endpoint IP addresses and hostnames for a DNS location:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Gateway** > **DNS locations**.
2. Locate the DNS location, then select **Configure**.
3. Go to **Setup instructions**. The addresses and hostnames will appear in **Your configuration**.

## DNS query location matching

Gateway uses different methods to match a DNS query to DNS locations depending on the type of request and network:

```mermaid
flowchart TB
    %% Accessibility
    accTitle: How Gateway matches queries to DNS locations
    accDescr: Flowchart describing the order of checks Cloudflare Gateway performs to determine the DNS location of a DNS query.

    %% Flowchart
    router(["Router"])-->gateway["Cloudflare Gateway"]

    gateway-->query{{"Is the DNS query sent over HTTPS?"}}

    query--"Yes"-->hostname["Look up location by<br />unique hostname"]
    query--"No"-->ipv4{{"Is it over IPv4?"}}

    ipv4--"Yes"-->source["Look up location by<br />source IPv4 address"]
    ipv4--"No"-->destination["Look up location by<br />destination IPv6 address"]
```

1. First, Gateway checks whether the query was sent using DNS over HTTPS. If yes, Gateway looks up the DNS location by its unique hostname.
2. Next, if the query was not sent with DNS over HTTPS, Gateway checks whether it was sent over IPv4. If yes, it looks up the DNS location by the source IPv4 address.
3. Last, if the query was not sent over IPv4, it means it was sent over IPv6. Gateway will look up the DNS location associated with the query based on the unique DNS resolver IPv6 address.

## IPv4/IPv6 address

### Source IP

Gateway uses the public source IPv4 address of your network to identify your DNS location, apply policies, and log DNS requests. Unless you have purchased a [dedicated IPv4 resolver IP](#dedicated-dns-resolver-ip), you must provide source IP addresses for the IPv4 traffic you want to filter with DNS policies. Otherwise, Gateway will not be able to attribute the traffic to your account.

If you are on an Enterprise plan, you have the option of manually entering one or more source IP addresses of your choice. This enables you to create Gateway DNS locations even if you are not connecting from any of those networks' IP addresses.

### DNS resolver IP

When you create a DNS location, Gateway will resolve queries over IPv4 with the default DNS resolver IP addresses. These addresses are anycast IP addresses shared across every Cloudflare Zero Trust account. To resolve queries over IPv6, your location will receive and use a unique DNS resolver IPv6 address. These IP addresses are how Gateway will match DNS queries to locations and apply the appropriate filtering rules.

#### Dedicated DNS resolver IP

Enterprise users can request a dedicated DNS resolver IPv4 address to be provisioned for a DNS location instead of the default anycast addresses. Queries forwarded to that address will be identified using the dedicated DNS resolver IPv4 address.

Cloudflare will only assign resolver IP addresses to the Zero Trust account you request. For more information on requesting dedicated DNS resolver IPv4 addresses, contact your account team.

#### Bring your own DNS resolver IP

Enterprise users can use their own authority-provided IPv4 and IPv6 addresses as DNS endpoints for a location. Gateway can resolve UDP, TCP, DoT, and DoH queries through the IPv4 addresses provided, as well as UDP and TCP queries through the IPv6 addresses provided.

After you onboard your IP addresses, the IP addresses will appear under the associated endpoint when you create a new DNS location. If you did not provide IP addresses for a specific endpoint type, you can use the default Cloudflare resolver IPs or dedicated resolver IPs alongside your own resolver IPs. For example, if you want to use the IPv6 endpoint but only provided IPv4 addresses, you can use your own resolver IPs for IPv4 and the default Cloudflare IPs for IPv6.

For more information, refer to [Cloudflare BYOIP](https://developers.cloudflare.com/byoip/) or contact your account team.

## DNS over TLS (DoT)

Each DNS location is assigned a unique hostname for DNS over TLS (DoT). Gateway will identify your location based on its DoT hostname.

## DNS over HTTPS (DoH)

Each DNS location is assigned a unique hostname for DNS over HTTPS (DoH). Gateway will identify your location based on its DoH hostname.

### DoH subdomain

Each DNS location in Cloudflare Zero Trust has a unique DoH subdomain (previously known as unique ID). If your organization uses DNS policies, you can enter your location's DoH subdomain as part of the WARP client settings.

For example, for the DoH hostname `https://65y9p2vm1u.cloudflare-gateway.com/dns-query`, the DoH subdomain is `65y9p2vm1u`.

## Send specific queries to Gateway

By default, all queries from a configured DNS location will be sent to its DNS resolver IP address to be inspected by Gateway. You can configure Gateway to only filter queries originating from specific networks within a location:

1. [Create an IP list](https://developers.cloudflare.com/cloudflare-one/traffic-policies/lists/) with the IPv4 and/or IPv6 addresses that your organization will source queries from.
2. Add a [Source IP](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/#source-ip) condition to your DNS policies.

For example, to block security threats for specific networks, you could create the following policy:

| Selector | Operator | Value | Logic | Action |
| - | - | - | - | - |
| Security Categories | in | Select all categories that apply | And | Block |
| Source IP | in list | The name of the IP list containing your organization's networks | | |

DNS queries made from IP addresses that are not in your IP list will not be filtered or populate your organization's [Gateway activity logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/).
