---
title: About Cloudflare WARP · Cloudflare Zero Trust docs
description: The Cloudflare WARP client allows you to protect corporate devices
  by securely and privately sending traffic from those devices to Cloudflare's
  global network, where Cloudflare Gateway can apply advanced web filtering. The
  WARP client also makes it possible to apply advanced Zero Trust policies that
  check for a device's health before it connects to corporate applications.
lastUpdated: 2025-10-23T22:25:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/index.md
---

## About Cloudflare WARP

The Cloudflare WARP client allows you to protect corporate devices by securely and privately sending traffic from those devices to Cloudflare's global network, where [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) can apply advanced web filtering. The WARP client also makes it possible to apply advanced [Zero Trust policies](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/) that check for a device's health before it connects to corporate applications.

## How WARP works

WARP is a device client that builds proxy tunnels using either Wireguard or MASQUE, and builds a DNS proxy using DNS-over-HTTPS. WARP supports all major operating systems, all common forms of endpoint management tooling, and has a robust series of management parameters and profiles to accurately scope the needs of a diverse user base.

The WARP client consists of:

* Graphical User Interface (GUI): Control panel that allows end users to view WARP's [status](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/) and perform actions such as turning WARP on or off.
* WARP daemon (or service): Core background component responsible for establishing secure tunnels (using WireGuard or MASQUE) and handling all WARP functionality on your device.

For more information on how the WARP client routes traffic, refer to the [WARP architecture page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/) and watch the video below.

## WARP installation details

The GUI and daemon (or service) have different names and are stored in the following locations:

Windows

| | Windows |
| - | - |
| **Service / Daemon** | `C:\Program Files\Cloudflare\Cloudflare WARP\warp-svc.exe` |
| **GUI application** | `C:\Program Files\Cloudflare\Cloudflare WARP\Cloudflare WARP.exe` |
| **Logs Location** | Daemon`C:\ProgramData\Cloudflare\` GUI Logs`C:\Users\<USER>.WARP\AppData\Local` or `%LOCALAPPDATA%\Cloudflare` |

macOS

| | macOS |
| - | - |
| **Service / Daemon** | `/Applications/Cloudflare WARP.app/Contents/Resources/CloudflareWARP` |
| **GUI application** | `/Applications/Cloudflare WARP.app/Contents/MacOS/Cloudflare WARP` |
| **Logs Location** | Daemon`/Library/Application Support/Cloudflare/`GUI Logs`~/Library/Logs/Cloudflare/` |

Linux

| | Linux |
| - | - |
| **Service / Daemon** | `/bin/warp-svc` |
| **GUI application** | `/bin/warp-taskbar` |
| **Logs Location** | `/var/log/cloudflare-warp/` `/var/lib/cloudflare-warp` |

Along with the WARP GUI and daemon, `warp-cli` and `warp-diag` are also [installed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/) on the machine and added to the system path for use from any terminal session.

[`warp-diag`](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/warp-logs/) is a command-line diagnostics tool that collects logs, configuration details, and connectivity data from the WARP client to help troubleshoot issues.

`warp-cli` is the command-line interface (CLI) for managing and configuring the Cloudflare WARP client, allowing users to connect, disconnect, and adjust settings programmatically.

## Key benefits of using WARP

Deploying the WARP client significantly enhances your organization's security and visibility within Cloudflare Zero Trust:

* **Unified security policies everywhere**: With the WARP client deployed in the Gateway with WARP mode, [Gateway policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) are not location-dependent — they can be enforced anywhere.

* **Advanced web filtering and threat protection**: Activate Gateway features for your device traffic, including:

  * [Anti-Virus scanning](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/antivirus-scanning/)
  * [HTTP filtering](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/)
  * [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#isolate)
  * [Identity-based policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/)

* **Application and device-specific insights**: With WARP installed on your corporate devices, you can view detailed application and user-level activity on the [Zero Trust Shadow IT Discovery](https://developers.cloudflare.com/cloudflare-one/insights/analytics/shadow-it-discovery/) page, while also monitoring device and network performance with [Digital Experience Monitoring (DEX)](https://developers.cloudflare.com/cloudflare-one/insights/dex/) to proactively detect and resolve issues.

* **Device posture checks**: The WARP client provides advanced Zero Trust protection by making it possible to check for [device posture](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/). By setting up device posture checks, you can build Zero Trust policies that check for a device's location, disk encryption status, OS version, and more.

* **Secure private and infrastructure access**: WARP lets devices connect to [private networks](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/) over Cloudflare Tunnel and is required for [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/), enabling secure SSH with short-lived certificates and detailed logging.

## WARP modes

WARP offers flexible [operating modes](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) to suit your specific needs. WARP can control device traffic as a full proxy, manage only DNS traffic as a DNS proxy, or both. WARP is the most common method for sending user device traffic through Cloudflare Gateway for filtering and decryption.

## Next steps

* Review the [first-time setup](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/set-up-warp/) guide to [install](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/) and [deploy](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) the WARP client on your corporate devices.
* Review possible [WARP modes](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) and [settings](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/) to best suit your organization's needs.
* Explore [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) to enforce advanced DNS, network, HTTP, and egress policies with WARP.
