---
title: Traffic policies · Cloudflare Zero Trust docs
description: Cloudflare Gateway, our comprehensive Secure Web Gateway, allows
  you to set up policies to inspect DNS, Network, HTTP, and Egress traffic.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/index.md
---

Cloudflare Gateway, our comprehensive [Secure Web Gateway](https://www.cloudflare.com/learning/access-management/what-is-a-secure-web-gateway/), allows you to set up policies to inspect DNS, Network, HTTP, and Egress traffic.

* **DNS policies** inspect DNS queries. You can block domains and IP addresses from resolving on your devices. For more information on DNS filtering, refer to our [Learning Center article](https://www.cloudflare.com/learning/access-management/what-is-dns-filtering/).
* **Network policies** inspect individual TCP/UDP/GRE packets. You can block access to specific ports on your origin server, including non-HTTP resources.
* **HTTP policies** inspect HTTP requests. You can block specific URLs from loading, not just the domain itself. For more information on URL filtering, refer to our [Learning Center article](https://www.cloudflare.com/learning/access-management/what-is-url-filtering/).
* **Egress policies** inspect traffic to assign egress IP addresses unique to your organization.
* **Resolver policies** inspect DNS queries to enable resolution by custom authoritative nameservers.

Note

When creating or editing policies, it may take up to 60 seconds for that policy to be updated across all of Cloudflare's data centers.

## Best practices

For each type of policy, we recommend the following workflow:

1. Connect the devices and/or networks that you want to apply policies to.
2. Verify that Gateway is successfully proxying traffic from your devices.
3. Set up basic security and compatibility policies (recommended for most use cases).
4. Customize your configuration to the unique needs of your organization.

To get started with specific Gateway filtering types, refer to the initial setup for [DNS](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/dns/), [Network](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/network/), and [HTTP](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/http/) policies.

### Select a policy type

The recommended policy type depends on what kind of traffic you are trying to filter. For example:

* To block websites, create an HTTP policy.
* To block non-HTTP traffic such as SSH and RDP, create a network policy.
* To block malware and other security threats, create both DNS and HTTP policies.
* To assign static IP addresses to your organization's egress traffic, create an egress policy.

Refer to the [DNS](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/), [network](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/), [HTTP](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/), and [egress](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/) configuration pages to see the available filtering options within each policy builder.
