---
title: Google Workspaces directory integration · Cloudflare Email Security
  (formerly Area 1) docs
description: Email Security can integrate with Google to retrieve user and group
  information. This can be used to enforce the Business Email Compromise
  configuration to prevent user impersonation.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-security/email-configuration/enhanced-detections/business-email-compromise/gworkspaces-directory-guide/
  md: https://developers.cloudflare.com/email-security/email-configuration/enhanced-detections/business-email-compromise/gworkspaces-directory-guide/index.md
---

Email Security can integrate with Google to retrieve user and group information. This can be used to enforce the Business Email Compromise configuration to prevent user impersonation.

## 1. Create a service account in Google for Email Security Directory Integration

You need to authorize Email Security to make connections into your Google tenant to retrieve your directory details. Cloudflare recommends that you create a service account for this purpose. This account will require the following following privileges:

* View group subscriptions on your domain.
* View organization units on your domain.
* View groups on your domain.
* See info about users on your domain.

Start by creating a service account. If you already have one, you can skip this step.

1. Access your [Google admin console](https://admin.google.com/), and go to **Account** > **Admin roles**.

   ![Access the admin console in your Google account](https://developers.cloudflare.com/_astro/step1-access-gadmin.CQkN9gbr_ZTsucX.webp)

2. Select **Create new role**, and give it a descriptive name and description. When you are finished, select **Continue**.

3. In **Admin console privileges**, select the following privileges:

   * *Organizational Units > Read*
   * *Users > Read*
   * *Directory Settings > Settings >Google Support Settings*
   * *Directory Sync > Manage Directory Sync Settings > Read Directory Sync Settings*

   ![Select only the privileges mentioned here](https://developers.cloudflare.com/_astro/step3-console-privileges.vFqEU1es_Z1optTG.webp)

4. When you specify Admin console privileges, you also grant the corresponding Admin API privileges. In any case, make sure the following privileges are selected for **Admin API privileges**:

   * *Organizational Units > Read*
   * *Users > Read*
   * *Groups > Read*

   ![Select only the privileges mentioned here](https://developers.cloudflare.com/_astro/step4-api-privileges.Cd1euJz-_1eT6Ix.webp)

5. Select **Continue**.

6. Review your information and select **Create Role**.

## 2. Authorize Email Security for Directory Access with Google

1. Log in to the [Email Security dashboard](https://horizon.area1security.com/), and select **Settings** (the gear icon).

2. Go to **Directories**, and select **Add Directory** to start the authorization process.

   ![Go to Directories in the dashboard of Email Security, and then select Add Directory to start the authorization process](https://developers.cloudflare.com/_astro/step2-directories.D22k3b5I_Z2pynUM.webp)

3. In the Add Directory configuration panel, enter the following details:

   * **Directory Type**: Open the drop-down menu and select **Google**.
   * **Directory Name**: Enter a string that represents the directory. This value will be referenced in the Business Email Compromise List configuration section. For example, `Gmail`.
   * **Sync Frequency**: Update the value to your preference.

   Select **Authorize** when you are done.

4. The Email Security dashboard will redirect you to a Google login page. Select or enter the appropriate account to initiate the authentication process.

5. Once authenticated, the system will show a dialog box with a list of the required permissions. Check all the checkboxes, and select **Continue** to authorize the change.

   ![Select all the settings to authorize Google](https://developers.cloudflare.com/_astro/step5-authorize-google.BLbvhcCy_ZyIIqK.webp)

6. Upon authorization, you will be automatically redirected back to the Add Directory configuration panel. Select **Save** to complete the authorization process.

   ![Select Save to complete the authorization process](https://developers.cloudflare.com/_astro/step6-save.D3QFRqJX_Z1KDMQr.webp)

7. Once saved, your newly configured directory will appear in the configured directories table.

   ![Your directory will appear in the configured directories table](https://developers.cloudflare.com/_astro/step7-directories.X-76CIOe_19aOhA.webp)

## 3. Configure the Business Email Compromise list

Now that Email Security (formerly Area 1) has been authorized to access and retrieve directory information, you will need to configure the Business Email Compromise list.

1. Log in to the [Email Security (formerly Area 1) dashboard](https://horizon.area1security.com/), and select **Settings** (the gear icon).

2. Go to **Email Configuration** > **Enhanced Detections** > **Business Email Compromise**.

   ![Access Business Email Compromise in Email Security (formerly Area 1) dashboard to start setting up this feature](https://developers.cloudflare.com/_astro/step2-business-email-compromise.JLn7Jc_Z_ZUFG4J.webp)

3. Open the drop-down menu and select the directory you have created in the previous step 3.

   ![Select the directory you have created in the previous step 3](https://developers.cloudflare.com/_astro/step3-office365.DovwiIDh_Z1sV2Cc.webp)

4. If the initial directory synchronization has completed, the page will refresh and list groups and users. If you do not see any information, wait a few minutes as the system completes processing the initial synchronization.

   ![The screen should refresh and show a list of users and groups](https://developers.cloudflare.com/_astro/step4-business-list.CpO6oJT4_moqQF.webp)

5. Select the arrow next to a group to expand it and show its members.

   ![Select the arrow to expand it and show a list of its members](https://developers.cloudflare.com/_astro/step5-show-members.DDOL6mZ3_Z22IF1S.webp)

6. To protect an entire group, select the three-dots button next to it, and then select **Protect**. When you protect a group, all of its members will be automatically protected. The protection markers will turn green to indicate that protection is active.

   ![You can protect an entire group of users. The protection markers will turn green to show that protection is active](https://developers.cloudflare.com/_astro/step6-protect-group.Dp7Ice3T_Who9v.webp)

7. You can also protect individual users. Select the three-dots button next to each user you want to protect, and then select **Protect**.

## 4. Configure secondary email address (if required)

When the Business Email Compromise list is configured, Email Security (formerly Area 1) will enforce the proper match of the sender’s display name and email address. Any variation from this strict requirement will raise a detection event. The reason of detection will be `Protected Name <NAME> should not appear as <non-configured email address>`.

In some instances, you may want to allow your protected users to send emails from an alternate email address (like their personal email address). To configure this alternate address, you will have to add it to their directory entry.

1. Log in to the [Email Security (formerly Area 1) dashboard](https://horizon.area1security.com/), and select **Settings** (the gear icon).

2. Go to **Email Configuration** > **Enhanced Detections** > **Business Email Compromise**.

3. Search for the user you want to allow an alternate email address.

4. Select the three-dots button > **Edit**.

   ![Select edit to add alternate email addresses to your user](https://developers.cloudflare.com/_astro/step4-edit-user.DL6F3KAq_ZD7GcV.webp)

5. In **Secondary Emails** add the additional email addresses. Place each entry on a new line.

   ![Add each new email address to the Secondary Emails field. Place each address on a separate line](https://developers.cloudflare.com/_astro/step5-new-email.B-eIH6gr_zbom5.webp)

6. Select **Save** to finish.
