---
title: Configure routes · Cloudflare Learning Paths
description: Magic Networking uses a routing table to steer your traffic via
  next-hop from Cloudflare's global network to your connected networks. Entries
  can be added to the Magic routing table via static route configuration or via
  routes learned through BGP peering (only available over Direct CNI).
lastUpdated: 2025-09-08T09:58:37.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/data-center-protection/configure-tunnels-routes/configure-routes/
  md: https://developers.cloudflare.com/learning-paths/data-center-protection/configure-tunnels-routes/configure-routes/index.md
---

Magic Networking uses a routing table to steer your traffic via next-hop from Cloudflare's global network to your connected networks. Entries can be added to the Magic routing table via static route configuration or via routes learned through BGP peering (only available over Direct CNI).

Refer to [Traffic Steering](https://developers.cloudflare.com/magic-transit/reference/traffic-steering/) for more information about all the technical aspects related to:

* Routes' priorities and weights
* Regional scoping of traffic to reduce latency
* BGP peering

Anycast routing

Remember that Cloudflare uses anycast to route traffic. Anycast is a network addressing and routing method in which incoming requests can be routed to a variety of different locations. Because of this, traffic might land in a different geographic location than expected. Not all requests are sent to the closest data center due to the complex nature of Internet routing and peering relationships, and how Cloudflare optimizes for performance and reliability.

## Configure static routes

### Create a static route

* Dashboard

  1. In the Cloudflare dashboard, go to Magic Transit's **Configuration** page.

     [Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/magic-transit/configuration)

  2. From the **Routes** tab, select **Create** to add a new route.

  3. Enter a descriptive name for your route in **Description**.

  4. In **Prefix**, enter your range of IP addresses. For example, `10.10.10.100/24`.

  5. In **Tunnel/Next hop** select which tunnel you want your route to go through. Choose from the tunnels you have created in [Configure tunnel endpoints](https://developers.cloudflare.com/magic-transit/how-to/configure-tunnel-endpoints/).

  6. Choose the **Priority** for your route. Lower numbers have higher priorities.

     Note

     Cloudflare routing applies longest-prefix match. A more specific static route (like `/30`) will always be preferred over a less specific one (like `/29`), regardless of tunnel priority — unless the more specific route is removed.

     Have this in mind when configuring priorities for your routes. Refer to [Route prioritization](https://developers.cloudflare.com/magic-transit/reference/traffic-steering/#route-prioritization) for more information.

  7. (Optional) Choose a **Weight** for your route. Refer to [Set priority and weights for static routes](https://developers.cloudflare.com/magic-transit/reference/traffic-steering/#set-priority-and-weights-for-static-routes) for examples.

  8. (Optional) If you need to scope your route to a specific region, you can do it in **Region code**.

  9. (Optional) We highly recommend testing your route before adding it by selecting **Test routes**.

  10. Select **Add routes** when you are done.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  Create a `POST` request [using the API](https://developers.cloudflare.com/api/resources/magic_transit/subresources/routes/methods/create/) to create one or more static routes.

  Example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Magic WAN Write`
  * `Magic Transit Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/routes" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "nexthop": "<IP_NEXT_HOP>",
      "prefix": "<YOUR_IP_PREFIX>",
      "priority": 0,
      "id": "023e105f4ecef8ad9ca31a8372d0c353",
      "description": "<ROUTE_DESCRIPTION>",
      "scope": {
          "colo_names": [
              "den01"
          ],
          "colo_regions": [
              "APAC"
          ]
      },
      "weight": 0
    }'
  ```

  ```json
  {
    "errors": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "messages": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "result": {
      "routes": [
        {
          "nexthop": "203.0.113.1",
          "prefix": "192.0.2.0/24",
          "priority": 0,
          "id": "023e105f4ecef8ad9ca31a8372d0c353",
          "description": "New route for new prefix 203.0.113.1",
          "scope": {
            "colo_names": [
              "den01"
            ],
            "colo_regions": [
              "APAC"
            ]
          },
          "weight": 0
        }
      ]
    },
    "success": true
  }
  ```

### Edit a static route

* Dashboard

  1. In **Routes**, select **Edit** next to the route you want to modify.
  2. Enter the updated route information.
  3. (Optional) We highly recommend testing your route before adding it by selecting **Test routes**.
  4. Select **Edit routes** to save the new information when you are done.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  Create a `PUT` request [using the API](https://developers.cloudflare.com/api/resources/magic_transit/subresources/routes/methods/update/) to update one or more static routes.

  Example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Magic WAN Write`
  * `Magic Transit Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/routes/$ROUTE_ID" \
    --request PUT \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "nexthop": "<IP_NEXT_HOP>",
      "prefix": "<YOUR_IP_PREFIX>",
      "priority": 0,
      "id": "023e105f4ecef8ad9ca31a8372d0c353",
      "description": "<ROUTE_DESCRIPTION>",
      "scope": {
          "colo_names": [
              "den01"
          ],
          "colo_regions": [
              "APAC"
          ]
      },
      "weight": 0
    }'
  ```

  ```json
  {
    "errors": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "messages": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "result": {
      "modified": true,
      "modified_route": {
        "nexthop": "203.0.113.1",
        "prefix": "192.0.2.0/24",
        "priority": 0,
        "id": "023e105f4ecef8ad9ca31a8372d0c353",
        "description": "New route for new prefix 203.0.113.1",
        "scope": {
          "colo_names": [
            "den01"
          ],
          "colo_regions": [
            "APAC"
          ]
        },
        "weight": 0
      }
    },
    "success": true
  }
  ```

### Delete static route

* Dashboard

  1. In **Routes**, locate the static route you want to modify and select **Delete**.
  2. Confirm the action by selecting the checkbox and select **Delete**.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  Create a `DELETE` request [using the API](https://developers.cloudflare.com/api/resources/magic_transit/subresources/routes/methods/delete/) to delete a static route.

  Example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Magic WAN Write`
  * `Magic Transit Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/routes/$ROUTE_ID" \
    --request DELETE \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
  ```

  ```json
  {
    "errors": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "messages": [
      {
        "code": 1000,
        "message": "message"
      }
    ],
    "result": {
      "deleted": true,
      "deleted_route": {
        "nexthop": "203.0.113.1",
        "prefix": "192.0.2.0/24",
        "priority": 0,
        "id": "023e105f4ecef8ad9ca31a8372d0c353",
        "description": "New route for new prefix 203.0.113.1",
        "scope": {
          "colo_names": [
            "den01"
          ],
          "colo_regions": [
            "APAC"
          ]
        },
        "weight": 0
      }
    },
    "success": true
  }
  ```

## Configure BGP routes

BGP peering is available when using a [Direct CNI](https://developers.cloudflare.com/network-interconnect/) as an on-ramp.

### Choose an ASN for BGP peering

The Magic routing table is managed by the customer, who can select both the Cloudflare-side ASN and the ASN for their customer device. The customer device ASN can be 2-byte or 4-byte. [Public ASNs used for Magic Transit](https://developers.cloudflare.com/magic-transit/how-to/advertise-prefixes/#cloudflare-asn-vs-your-own-asn) are verified during the onboarding process.

By default, each BGP peering session will use the same Cloudflare-side ASN to represent peering with the Magic Transit routing table. This ASN is called the **CF Account ASN** and is set to `13335`. This can be configured to a private 2-byte ASN (for example, any values between `64512` and `65534`). To set this ASN:

1. In the Cloudflare dashboard, go to Magic Transit's **Configuration** page.

   [Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/magic-transit/configuration)

2. Go to **BGP configuration**.

3. In **CF Account ASN**, enter Cloudflare's ASN.

4. Select **Update**.

Magic Transit customers should also be aware of the following:

* The Cloudflare side ASN will never be exposed in `AS_PATH` of anycast announcements from the Cloudflare edge. In those announcements, Cloudflare will always use the Cloudflare ASN of `13335` optionally prepended with a bring-your-own ASN as described in [Cloudflare ASN vs. your own ASN](https://developers.cloudflare.com/magic-transit/how-to/advertise-prefixes/#cloudflare-asn-vs-your-own-asn).
* The customer device ASN can be a private ASN or the ASN they are using for Magic Transit anycast announcements at the edge: this has no impact on the ASN for the anycast announced prefix at the edge of the Cloudflare global network.

### Set up BGP peering

Warning

BGP peering is only available to Magic Transit customers with Direct CNI as an on-ramp. If your network is set up with GRE or IPsec tunnels, you cannot use BGP peering.

You need to configure two ASNs:

* The Cloudflare [account-scoped ASN](#choose-an-asn-for-bgp-peering) named **CF Account ASN**.
* One ASN for each interconnect you want to configure with BGP.

If you already have set up your Cloudflare account ASN, you can skip steps two and three below.

1. In the Cloudflare dashboard, go to Magic Transit's **Configuration** page.

   [Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/magic-transit/configuration)

2. Go to **BGP configuration**.

3. In **CF Account ASN**, enter Cloudflare's ASN.

4. Go to **Interconnects**.

5. Find the Direct CNI interconnect you want to configure with BGP > select the **three dots** next to it > **Configure BGP**.

6. In **Customer device ASN**, enter the ASN for your network.

7. In **MD5 key**, you can optionally enter the key for your network. Note that this is meant to prevent accidental misconfigurations, and is not a security mechanism.

8. (Optional) In **Advertised prefix list**, input the additional prefixes automatically assigned by Cloudflare during the creation of the CNI interconnect, to advertise alongside your existing routes. Leave blank if you do not want to advertise extra routes.\
   Typical prefixes to configure here include:

   * A route to `0.0.0.0/0`, the default route — to attract all Internet-bound traffic if using Magic Transit with Egress.
   * A route to `100.96.0.0/12`, the portion of CGNAT space [used by default with WARP clients](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/user-to-site/#add-route-to-router).

9. Select **Save**.
