---
title: Enable TLS decryption (optional) · Cloudflare Learning Paths
description: TLS decryption allows Cloudflare Gateway to inspect HTTPS requests
  to your private network applications.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/replace-vpn/configure-device-agent/enable-tls-decryption/
  md: https://developers.cloudflare.com/learning-paths/replace-vpn/configure-device-agent/enable-tls-decryption/index.md
---

[TLS decryption](https://www.cloudflare.com/learning/security/what-is-https-inspection/) allows Cloudflare Gateway to inspect HTTPS requests to your private network applications.

## Should I enable TLS decryption?

With TLS decryption turned on, you can apply advanced Gateway policies, such as:

* Filtering based on the complete URL and path of requests
* Scanning for sensitive data with [Cloudflare Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)
* Starting a remote browser isolation session with [Cloudflare Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)

These features can increase the security posture of sensitive systems, but TLS decryption can also break your users' access to certain resources. For instance, if your internal applications use self-signed certificates, you will need to either configure a [Do Not Inspect](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#do-not-inspect) policy or an [Untrusted certificate *Pass through*](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#untrusted-certificates) policy to allow users to connect. To learn more, refer to [TLS decryption limitations](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#inspection-limitations).

With TLS decryption turned off, Gateway can only inspect and apply HTTP policies to unencrypted HTTP requests. However, you can still apply network policies to HTTPS traffic based on user identity, device posture, IP, resolved domain, SNI, and other attributes that support a Zero Trust security implementation. For more information, refer to [Gateway network policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/).

## Enable TLS decryption

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Network**.
  2. In **Firewall**, turn on **TLS decryption**.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Zero Trust Write`

  2. Configure the `tls_decrypt` argument in [`cloudflare_zero_trust_gateway_settings`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_gateway_settings):

     ```tf
     resource "cloudflare_zero_trust_gateway_settings" "team_name" {
       account_id = var.cloudflare_account_id
       settings = {
         tls_decrypt = {
           enabled = true
         }
       }
     }
     ```

Next, choose a [user-side certificate](#configure-user-side-certificates) to use for inspection.

## Configure user-side certificates

When you enable TLS decryption, Gateway will decrypt all traffic sent over HTTPS, apply your HTTP policies, and then re-encrypt the request with a certificate on the user device. You can either [install the certificate provided by Cloudflare](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/automated-deployment/) (default option) or [upload a custom root certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/custom-certificate/) to Cloudflare (Enterprise-only option).

### Best practices

Deploying the Cloudflare root certificate is the simplest way to get started with TLS decryption and is usually appropriate for testing or proof of concept conditions.

If you already have a certificate that you use for other inspection or trust purposes, we recommend uploading your own root certificate for the following reasons:

* Using a single certificate streamlines IT management.
* If other services (such as `git` workflows, other CLI tools, or thick client applications) rely on an existing certificate store, presenting the same certificate in inspection is far less likely to interrupt their traffic flow.
* If you are using WARP Connector to connect devices to Cloudflare, those devices will not be able to leverage HTTP policies that require decrypting TLS unless they have a certificate that matches either your uploaded certificate or the Cloudflare root certificate. It is more likely that your network infrastructure already has your own device certificates deployed, so using the existing PKI infrastructure for inspection will reduce the number of steps needed to deploy Zero Trust.

MDM deployments

Many customers [deploy WARP](https://developers.cloudflare.com/learning-paths/replace-vpn/connect-devices/) onto devices in production using an MDM tool like JAMF or Intune. Cloudflare has the ability to deploy a root certificate along with the device, but this could be more consistently and holistically configured within the MDM, where other certificates are presumably managed, trusted, and stored.
