---
title: Create an allowlist or blocklist · Cloudflare Learning Paths
description: In the context of DNS filtering, a blocklist is a list of known
  harmful domains or IP addresses. An allowlist is a list of allowed domains or
  IP addresses, such as the domains of essential corporate applications.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-dns-policies/create-list/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-dns-policies/create-list/index.md
---

In the context of DNS filtering, a blocklist is a list of known harmful domains or IP addresses. An allowlist is a list of allowed domains or IP addresses, such as the domains of essential corporate applications.

Gateway supports creating [lists](https://developers.cloudflare.com/cloudflare-one/traffic-policies/lists/) of URLs, hostnames, or other entries to use in your policies.

## Example list policy

* Dashboard

  The following DNS policy will allow access to all approved corporate domains included in a list called **Corporate Domains**.

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Domain | in list | *Corporate Domains* | Allow |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-CorporateDomain-AllowList",
      "description": "Allow access to the corporate domains defined under the Corporate Domains list",
      "precedence": 1,
      "enabled": true,
      "action": "allow",
      "filters": [
          "dns"
      ],
      "traffic": "any(dns.domains[*] in $<CORPORATE_DOMAINS_LIST_UUID>)"
    }'
  ```

* Terraform

  To create a new DNS policy using **Terraform** to allow access to all approved corporate domains included in a list called **Corporate Domains**.

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "allow_corporate_domain_access" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-CorporateDomain-AllowList"
    description = "Allow access to the corporate domains defined under the Corporate Domains list"
    precedence  = 1
    enabled     = false
    action      = "allow"
    filters     = ["dns"]
    traffic     = "any(dns.domains[*] in $<Corporate Domains List UUID>)"
  }
  ```
