---
title: Test a policy · Cloudflare Learning Paths
description: It is common for a misconfigured Gateway policy to accidentally
  block traffic to benign sites. To ensure a smooth deployment, we recommend
  testing a simple policy before deploying DNS filtering to your organization.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-dns-policies/test-policy/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-dns-policies/test-policy/index.md
---

It is common for a misconfigured Gateway policy to accidentally block traffic to benign sites. To ensure a smooth deployment, we recommend testing a simple policy before deploying DNS filtering to your organization.

## Test a policy in the browser

1. Go to **Gateway** > **Firewall policies**.

2. Turn off all existing DNS policies.

3. Turn on any existing security policies or create a policy to block all security categories:

   | Selector | Operator | Value | Action |
   | - | - | - | - |
   | Security Categories | in | *All security risks* | Block |

4. Ensure that your browser is not configured to use an alternate DNS resolver. For example, Chrome has a **Use secure DNS** setting that will cause the browser to send requests to 1.1.1.1 and bypass your DNS policies.

5. In the browser, go to `malware.testcategory.com`. Your browser will display:

   * The Gateway block page, if your device is connected through the WARP client in Gateway with WARP mode.
   * A generic error page, if your device is connected through another method, such as Gateway with DoH mode.

Note

[Custom block pages](https://developers.cloudflare.com/cloudflare-one/traffic-policies/block-page/) require you to install a root certificate on the device.

1. In **Logs** > **Gateway** > **DNS**, verify that you see the blocked domain.
2. Slowly turn on or add other policies to your configuration.
3. When testing against frequently-visited sites, you may need to [clear the DNS cache](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/test-dns-filtering/#clear-dns-cache) in your browser or OS. Otherwise, the DNS lookup will return the locally-cached IP address and bypass your DNS policies.

You have now validated DNS filtering on a test device.
