---
title: Create your first HTTP policy · Cloudflare Learning Paths
description: Now that you have considered which devices and applications TLS
  inspection should and should not apply to, it is time to create your first
  HTTP policy.
lastUpdated: 2024-12-12T16:10:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-http-policies/create-policy/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-http-policies/create-policy/index.md
---

Now that you have considered which devices and applications TLS inspection should and should not apply to, it is time to create your first HTTP policy.

## Create your first policy

Use a standard naming convention when building all policies. Policy names should be unique across the Cloudflare account, follow the same structure, and be as descriptive as possible.

To create a new HTTP policy:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Gateway** > **Firewall policies**.

  2. In the **HTTP** tab, select **Add a policy**.

  3. Name the policy.

  4. Under **Traffic**, build a logical expression that defines the traffic you want to allow or block.

  5. Choose an **Action** to take when traffic matches the logical expression. For example, if you have configured TLS decryption, some applications that use [embedded certificates](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#inspection-limitations) may not support HTTP inspection, such as some Google products. You can create a policy to bypass inspection for these applications:

     | Selector | Operator | Value | Action |
     | - | - | - | - |
     | Application | in | *Do Not Inspect* | Do Not Inspect |

     Cloudflare also recommends adding a policy to block [known threats](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/#security-categories) such as Command & Control, Botnet and Malware based on Cloudflare's threat intelligence:

     | Selector | Operator | Value | Action |
     | - | - | - | - |
     | Security Categories | in | *All security risks* | Block |

  6. Select **Create policy**.

* API

  1. [Create an API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) with the following permissions:

     | Type | Item | Permission |
     | - | - | - |
     | Account | Zero Trust | Edit |

  2. (Optional) Configure your API environment variables to include your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and API token.

  3. Send a `POST` request to the [Create a Zero Trust Gateway rule](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/rules/methods/create/) endpoint. For example, if you have configured TLS decryption, some applications that use [embedded certificates](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#inspection-limitations) may not support HTTP inspection, such as some Google products. You can create a policy to bypass inspection for these applications:

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Zero Trust Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
       --request POST \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
       --json '{
         "name": "Do not inspect applications",
         "description": "Bypass TLS decryption for unsupported applications",
         "precedence": 0,
         "enabled": true,
         "action": "off",
         "filters": [
             "http"
         ],
         "traffic": "any(app.type.ids[*] in {16})",
         "identity": "",
         "device_posture": ""
       }'
     ```

     ```sh
     {
        "success": true,
        "errors": [],
        "messages": []
     }
     ```

     The API will respond with a summary of the policy and the result of your request.

     Cloudflare also recommends adding a policy to block [known threats](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/#security-categories) such as Command & Control, Botnet and Malware based on Cloudflare's threat intelligence:

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Zero Trust Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
       --request POST \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
       --json '{
         "name": "Block known risks",
         "description": "Block all default Cloudflare HTTP security categories",
         "precedence": 0,
         "enabled": true,
         "action": "block",
         "filters": [
             "http"
         ],
         "traffic": "any(http.request.uri.security_category[*] in {68 178 80 83 176 175 117 131 134 151 153})",
         "identity": "",
         "device_posture": ""
       }'
     ```

For more information, refer to [HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/).

## Order your policies

In most scenarios, Gateway evaluates HTTP policies in [top-down order](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/understand-policies/order-of-enforcement/) (like DNS policies). Because Do Not Inspect action policies are terminal actions, we recommend grouping them in logical order above all of your other policies because they will always functionally fire first regardless of where they are placed.

Once the Do Not Inspect policies are ordered correctly, Allow policies should follow, and the Allow policy descriptions should include any special considerations for Allow actions (such as header IDs, certificate mismatch handling, and non-isolate traffic).

Next, list your isolate and block policies. There may be scenarios in which you want to intermingle your block policies within your other policy outcomes. That is an acceptable approach, but you will need to ensure that you do not have overly permissive allows or overly restrictive block policies that will cause unintended effects.

## Test your policies

Before instituting blocks or other actions that would impact your users, first measure impact by setting the policy as an Allow action. Monitor your users' actions and look in your logs, sorting by that explicit policy, to see what traffic actions matched against it. If the activity is exactly what you would expect for the policy, you are probably safe to implement it as its intended action.

If your policy matches unexpected traffic flows or destinations (such as unintended users or device groups), review your policy to ensure it is not overly permissive or restrictive. If the policy design looks correct, determine whether other policies are matching before the intended policy. You can review the [order of enforcement](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/understand-policies/order-of-enforcement/) for Gateway policies to ensure all of your policies are working together as intended.
