---
title: Prepare for surges and mitigate DDoS attacks · Cloudflare Learning Paths
description: Utilize Cloudflare's caching to enhance load times and reduce
  server strain. Also, features like the Waiting Room and Rate Limiting can be
  used to effectively manage excess demand and ensure a stable user experience.
lastUpdated: 2025-09-25T16:31:00.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/surge-readiness/security/prepare-for-surges/
  md: https://developers.cloudflare.com/learning-paths/surge-readiness/security/prepare-for-surges/index.md
---

## Reduce server strain

Utilize Cloudflare's [caching](https://developers.cloudflare.com/cache/) to enhance load times and reduce server strain. Also, features like the [Waiting Room](https://developers.cloudflare.com/waiting-room) and [Rate Limiting](https://developers.cloudflare.com/waf/rate-limiting-rules/) can be used to effectively manage excess demand and ensure a stable user experience.

## Unlimited DDoS Protection

Cloudflare's Advanced [DDoS protection](https://developers.cloudflare.com/ddos-protection/) is always on for Enterprise customers and is used to mitigate DDoS attacks of all forms and sizes including those that target UDP and ICMP protocols, as well as SYN/ACK, DNS amplification, SMURF, and Layer 7 attacks.

## Browser Integrity Check

[Browser Integrity Check](https://developers.cloudflare.com/waf/tools/browser-integrity-check/) looks for requests with HTTP headers commonly used by spammers, bots, and crawlers such as requests with a missing or non-standard user agent. If a threat is found, Cloudflare will present a challenge page before allowing access. This may affect your API and can be selectively disabled using [Page Rules](https://developers.cloudflare.com/rules/page-rules/).
