---
title: Overview · Cloudflare Magic Network Monitoring docs
description: Magic Network Monitoring provides visibility into your network
  traffic and cloud traffic by analyzing network flow data sent from a
  customer's routers or cloud environment. Magic Network Monitoring supports
  NetFlow v5, NetFlow v9, IPFIX, and sFlow. In cloud environments, Magic Network
  Monitoring supports AWS VPC flow logs via AWS Firehose.
lastUpdated: 2025-09-08T16:19:34.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-network-monitoring/
  md: https://developers.cloudflare.com/magic-network-monitoring/index.md
---

Improve your network and cloud traffic visibility. Customers with public IPs can also detect DDoS attacks based on their traffic flows.

Available on all plans

Magic Network Monitoring provides visibility into your network traffic and cloud traffic by analyzing network flow data sent from a customer's routers or cloud environment. Magic Network Monitoring supports NetFlow v5, NetFlow v9, IPFIX, and sFlow. In cloud environments, Magic Network Monitoring supports AWS VPC flow logs via AWS Firehose.

Magic Network Monitoring is generally available to everyone with a Cloudflare account by default. You can log in to your Cloudflare dashboard, select your account, then go to the **Magic Monitoring** page to get started.

[Go to **Magic monitoring**](https://dash.cloudflare.com/?to=/:account/network-monitoring)

Everyone can use the [free version](https://developers.cloudflare.com/magic-network-monitoring/magic-network-monitoring-free/) of Magic Network Monitoring in a home network, network lab, or business to get end to end visibility across their network traffic. Potential enterprise customers are encouraged to use the free version to run a proof of concept.

Enterprise customers can use Magic Network Monitoring with [Magic Transit on-demand](https://developers.cloudflare.com/magic-transit/on-demand/) to monitor their network, identify volumetric DDoS attacks, and activate Magic Transit on-demand to mitigate those attacks.

Learn how to [get started](https://developers.cloudflare.com/magic-network-monitoring/get-started/).

***

## Features

### Rules

Create rules to configure the threshold for data flowing from your network.

[Use Rules](https://developers.cloudflare.com/magic-network-monitoring/rules/)

### Magic Transit integration

Magic Transit On Demand customers can use Magic Network Monitoring to enable DDoS mitigation when a DDoS attack is detected.

[Use Magic Transit integration](https://developers.cloudflare.com/magic-network-monitoring/magic-transit-integration/)

### Rule notifications

Set up notifications to learn about an attack.

[Use Rule notifications](https://developers.cloudflare.com/magic-network-monitoring/rules/rule-notifications/)

***

## Related products

**[Magic Transit](https://developers.cloudflare.com/magic-transit/)**

Mitigates L7, L4, and L3 DDoS attacks with Magic Network Monitoring with Magic Transit on-demand.

**[DDoS Protection](https://developers.cloudflare.com/ddos-protection/)**

Provides HTTP DDoS attack protection for zones onboarded to Cloudflare in addition to L3 and L4 DDoS attack protection.

**[Cloudflare Network Interconnect](https://developers.cloudflare.com/network-interconnect/)**

Connects your network infrastructure directly with Cloudflare - rather than using the public Internet - for a more reliable and secure experience.

## More resources

[Discord](https://discord.com/invite/cloudflaredev)

Connect with the Magic Network Monitoring community on Discord to ask questions, and share feedback.
