---
title: Troubleshooting · Cloudflare Page Shield docs
description: Cloudflare does not collect data on every single page view.
  Instead, it uses a sampling approach to gather information efficiently. This
  means that domains with lower traffic might take longer to generate initial
  reports, as these domains need more page views to accumulate enough samples.
  To speed up the reporting process, it is recommended that you actively
  generate traffic to your application after activating client-side resource
  monitoring. This will provide Cloudflare with more data to work with, leading
  to faster report generation.
lastUpdated: 2025-07-10T11:20:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/page-shield/troubleshooting/
  md: https://developers.cloudflare.com/page-shield/troubleshooting/index.md
---

## Cloudflare does not show any client-side resources after activation

Cloudflare does not collect data on every single page view. Instead, it uses a sampling approach to gather information efficiently. This means that domains with lower traffic might take longer to generate initial reports, as these domains need more page views to accumulate enough samples. To speed up the reporting process, it is recommended that you actively generate traffic to your application after [activating client-side resource monitoring](https://developers.cloudflare.com/page-shield/get-started/). This will provide Cloudflare with more data to work with, leading to faster report generation.

## The dashboard shows scripts and connections that I do not recognize

Scripts often reference other scripts outside your application.

But, if you see unexpected scripts on your resource monitoring dashboard, check them for signs of malicious activity.

## I get warnings in my browser's developer tools related to Content Security Policy (CSP)

Cloudflare uses a Content Security Policy (CSP) report-only directive to gather a list of all scripts running on your application.

Some browsers display scripts being reported as warnings in the console pane of their developer tools. For example:

```txt
[Report Only] Refused to execute inline script because it violates
the following Content Security Policy directive: "script-src 'none'".


Either the 'unsafe-inline' keyword, a hash ('sha256-RFWPLDbv2BY+rCkDzsE+0fr8ylGr2R2faWMhq4lfEQc='), or a nonce ('nonce-...')
is required to enable inline execution.
```

You can safely ignore these warnings, since they are related to the reports that Cloudflare requires to detect loaded scripts. For more information, refer to [How Page Shield works](https://developers.cloudflare.com/page-shield/how-it-works/).

## I get policy violation reports for a domain I allowlisted

Policy violations reported via CSP's [report-only directive](https://developers.cloudflare.com/page-shield/reference/csp-header/) do not take into consideration any redirects or redirect HTTP status codes. This is [by design](https://www.w3.org/TR/CSP3/#create-violation-for-request) for security reasons.

Some third-party services you may want to cover in your allow policies perform redirects. An example of such a service is Google Ads, which [does not work well with CSP policies](https://support.google.com/adsense/thread/102839782?hl=en\&msgid=103611259).

For example, if you add the `adservice.google.com` domain to an allow policy, you could get policy violation reports for this domain due to redirects to a different domain (not present in your allow policy). In this case, the violation report would still mention the original domain, and not the domain of the redirected destination, which can cause some confusion.

To try to solve this issue, add the domain of the redirected destination to your allow policy. You may need to add several domains to your policy due to redirects.
