---
title: "Reference Architecture Diagram: Securing data in transit · Cloudflare
  Reference Architecture docs"
description: Data in transit is often considered vulnerable to interception or
  tampering during transmission. Data Loss Prevention (DLP) technologies can be
  used to inspect the contents of network traffic and block sensitive data from
  going to a risky destination.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-in-transit/
  md: https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-in-transit/index.md
---

## Introduction

Data in transit typically means when it's traveling over the network. Because the Internet is made up of many thousands of networks, it is important to ensure your data is secure as it moves from device to server and back. These days, most common activities that generate data in transit are related to:

* Browsing online and uploading/download data to/from cloud applications
* Sending texts, pictures and emails
* Applications exposing and consuming data through APIs

Data in transit is often considered vulnerable to interception or tampering during transmission, so it is important to secure it through encryption techniques such as [QUIC](https://cloudflare-quic.com/), Transport Layer Security (TLS) or Secure Sockets Layer (SSL). This helps to ensure that the data remains confidential and protected from unauthorized access during its journey. There are other methods of inspecting data as it passes network boundaries to make decisions on if that data should continue to travel or not, Data Loss Prevention (DLP) technologies can be used to inspect the contents of network traffic and block sensitive data from going to a risky destination. This document outlines the methods Cloudflare has available to protect data in transit.

## Securing network connectivity

Cloudflare is one of the leading providers of cloud network security services. There are two main use cases Cloudflare is used to secure network traffic.

* Providing secure connectivity to public websites and APIs using SSL/TLS
* Creating secure tunnels to private networks and applications which are hosted either in the cloud or on-premises

Cloudflare's [SSL services](https://developers.cloudflare.com/ssl/) are used by millions of websites and are easily implemented by making changes to DNS entries, so that all connections to public websites and APIs are terminated on Cloudflare's edge network. Connectivity from Cloudflare to the destination website or API can also be secured using the same SSL technologies. To ensure the strongest security, Cloudflare uses [post quantum cryptography](https://blog.cloudflare.com/post-quantum-to-origins).

![Figure 1: Securing data from the user device, all the way to the website/API](https://developers.cloudflare.com/_astro/securing-data-in-transit-fig1.BeOrOaHa_ZYwhG7.svg)

1. Connection between user browser and Cloudflare secured by TLS/SSL
2. Connection from Cloudflare to destination server secured by TLS/SSL

Private resources, usually self hosted applications on private networks with no direct public Internet connection, require a different method of securing data in transit. There are a variety of different methods by which tunnels can be created from private networks to Cloudflare, more details on which can be found in the [SASE reference architecture](https://developers.cloudflare.com/reference-architecture/architectures/sase/), but the following diagram does a good job of summarizing the methods.

![Figure 2: Various methods of connecting and routing traffic to Cloudflare to secure private traffic.](https://developers.cloudflare.com/_astro/cf1-ref-arch-14.BMsYJBWD_155tSw.svg)

Once private applications and networks have been connected to Cloudflare, devices can then be connected securely via our device agent such that data from a user device, all the way across the network to an application can be secured.

When traffic from the device, to the hosted application, all flows via Cloudflare, it's possible for us to inspect the traffic and apply further security based on the content of the data.

## Inspecting traffic with Cloudflare DLP

A common challenge is trying to determine what data is sensitive and requires policy intervention. Data Loss Prevention services are used to inspect the contents of a piece of traffic, and then provide metadata to the policy to impact enforcement.

For example, when a user attempts to upload a file to a SaaS application and the traffic route has been configured to always go via the Cloudflare network, [Cloudflare DLP](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/) inspects the file by using DLP profiles assigned to a Gateway policy. After a DLP profile matches, the Gateway policy will allow or block the traffic, and the activity will be written to the logs. A DLP profile is a collection of regular expressions (also known as detection entries) that define the data patterns you want to detect. Cloudflare DLP provides [predefined profiles](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/#configure-a-predefined-profile) for common detections, or you can build [custom profiles](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/#build-a-custom-profile) specific to your data, and even the ability to leverage [Exact Data Match](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#exact-data-match) (EDM).

DLP profiles are then used in combination with other policy attributes to specifically identify the traffic, such as only enforcing the policy when sensitive data is being uploaded to approved Cloud based storage services.

![Figure 3: Example of a Cloudflare policy blocking confidential data uploaded to approved cloud storage.](https://developers.cloudflare.com/_astro/cf1-ref-arch-29.BGL4hCeF_Znjbgg.svg)

The following diagram shows a common flow for how Cloudflare inspects a request and enforces access based on a DLP based policy.

![Figure 4: Upload of file containing sensitive data blocked by Cloudflare DLP](https://developers.cloudflare.com/_astro/securing-data-in-transit-fig4.D-8KKTj8_2e5eUD.svg)

1. User attempts to upload a file to a SaaS application (via a secure tunnel to Cloudflare created by our [device agent](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/)). [Clientless](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/) options are supported as well.
2. Cloudflare's [Secure Web Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) (SWG) will first verify that the user is permitted to use the requested SaaS application, and then scrutinize the file's payload for [malicious code](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/antivirus-scanning/) and [sensitive data](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/).
3. The DLP profile determines the file contains national identifiers like US Social Security Numbers (SSN).
4. The Gateway policy is configured with a [Block action](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#block), so the attempt is [logged](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#log-the-payload-of-matched-rules) and a [block page](https://developers.cloudflare.com/cloudflare-one/traffic-policies/block-page/) returned to the end user's web browser.

## Related resources

* [Securing data in use](https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-in-use/)
* [Securing data at rest](https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-at-rest/)
