---
title: Redirect requests from one country to a domain · Cloudflare Rules docs
description: Create a redirect rule to redirect all website visitors from the
  United Kingdom to a different domain, maintaining the current functionality in
  the same paths.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-country/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-country/index.md
---

In this example, all website visitors from the United Kingdom will be redirected to a different domain, but maintaining current functionality in the same paths.

1. Create a Bulk Redirect List named `uk_redirect_list` with the following URL redirect:

   * **Source URL**: `https://example.com/`
   * **Target URL**: `https://example.co.uk/`
   * **Subpath matching**: Enabled
   * **Preserve query string**: Enabled

2. Create a Bulk Redirect Rule that enables the previous Bulk Redirect List and set the rule expression to the following:

   ```txt
   ip.src.country == "GB" and http.request.full_uri in $uk_redirect_list
   ```

This configuration will perform the following redirects for UK visitors:

| Request URL | URL after redirect |
| - | - |
| `https://example.com/` | `https://example.co.uk/` |
| `https://example.com/my/path/to/page.htm` | `https://example.co.uk/my/path/to/page.htm` |
| `https://example.com/search?q=term` | `https://example.co.uk/search?q=term` |
