---
title: Deploy a custom ruleset · Cloudflare Ruleset Engine docs
description: Learn how to deploy a custom ruleset to your Cloudflare account.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/custom-rulesets/deploy-custom-ruleset/
  md: https://developers.cloudflare.com/ruleset-engine/custom-rulesets/deploy-custom-ruleset/index.md
---

To deploy a custom ruleset, add a rule with `execute` action to the list of rules of a phase [entry point ruleset](https://developers.cloudflare.com/ruleset-engine/about/rulesets/#entry-point-ruleset) at the account level. The expression of the new rule will define when the custom ruleset will run.

If you are using Terraform, refer to [WAF custom rules configuration using Terraform](https://developers.cloudflare.com/terraform/additional-configurations/waf-custom-rules/#create-and-deploy-a-custom-ruleset) for examples of creating and deploying custom rulesets.

If you are using the Cloudflare dashboard, refer to [Work with custom rulesets in the dashboard](https://developers.cloudflare.com/waf/account/custom-rulesets/create-dashboard/).

## Before you begin

1. Obtain the name of the [phase](https://developers.cloudflare.com/ruleset-engine/reference/phases-list/) where you want to deploy the custom ruleset.
2. [Create a custom ruleset](https://developers.cloudflare.com/ruleset-engine/custom-rulesets/create-custom-ruleset/) and keep the ID of the new custom ruleset.
3. [Fetch the rules already present in the phase entry point ruleset](https://developers.cloudflare.com/ruleset-engine/basic-operations/view-rulesets/#view-the-rules-included-in-a-ruleset). You must include in the `PUT` request all existing rules you want to keep.

## Example

The following `PUT` request adds a rule that executes a custom ruleset when the zone name matches `example.com`. The response will include all the rules in the phase entry point ruleset.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Mass URL Redirects Write`
* `Magic Firewall Write`
* `L4 DDoS Managed Ruleset Write`
* `Transform Rules Write`
* `Select Configuration Write`
* `Account WAF Write`
* `Account Rulesets Write`
* `Logs Write`

```bash
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/rulesets/phases/http_request_firewall_custom/entrypoint" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "rules": [
        {
            "action": "execute",
            "description": "Execute custom ruleset",
            "expression": "(cf.zone.name == \"example.com\") and cf.zone.plan eq \"ENT\"",
            "action_parameters": {
                "id": "<CUSTOM_RULESET_ID>"
            }
        },
        {
            "id": "<EXISTING_PHASE_RULE_ID_1>"
        },
        {
            "id": "<EXISTING_PHASE_RULE_ID_2>"
        }
    ]
  }'
```

```json
{
  "result": {
    "id": "<ACCOUNT_PHASE_RULESET_ID>",
    "name": "http_request_firewall_custom phase entry point ruleset for my account",
    "description": "Execute several rulesets",
    "kind": "root",
    "version": "3",
    "rules": [
      {
        "id": "<PHASE_RULE_ID>",
        "version": "1",
        "action": "execute",
        "description": "Execute custom ruleset",
        "action_parameters": {
          "id": "<CUSTOM_RULESET_ID>",
          "version": "latest"
        },
        "expression": "(cf.zone.name == \"example.com\") and cf.zone.plan eq \"ENT\"",
        "last_updated": "2021-03-18T18:35:14.135697Z",
        "ref": "<PHASE_RULE_REF>",
        "enabled": true
      },
      {
        "id": "<EXISTING_PHASE_RULE_ID_1>",
        "version": "1",
        "action": "execute",
        "action_parameters": {
          "id": "<EXECUTED_RULESET_ID_1>",
          "version": "latest"
        },
        "expression": "(cf.zone.name eq \"example.com\") and cf.zone.plan eq \"ENT\"",
        "last_updated": "2021-03-16T15:51:49.180378Z",
        "ref": "<EXISTING_PHASE_RULE_REF_1>",
        "enabled": true
      },
      {
        "id": "<EXISTING_PHASE_RULE_ID_2>",
        "version": "1",
        "action": "execute",
        "action_parameters": {
          "id": "<EXECUTED_RULESET_ID_2>",
          "version": "latest"
        },
        "expression": "(cf.zone.name eq \"example.com\") and cf.zone.plan eq \"ENT\"",
        "last_updated": "2021-03-16T15:50:29.861157Z",
        "ref": "<EXISTING_PHASE_RULE_REF_2>",
        "enabled": true
      }
    ],
    "last_updated": "2021-03-18T18:35:14.135697Z",
    "phase": "http_request_firewall_custom"
  },
  "success": true,
  "errors": [],
  "messages": []
}
```

Warning

Regarding the expression of the rule deploying the ruleset, you must use parentheses to enclose any custom conditions and end your expression with `and cf.zone.plan eq "ENT"` or else the API operation will fail.
