---
title: RSSButton · Cloudflare Style Guide
description: A button component for RSS feed subscriptions.
lastUpdated: 2025-04-04T20:34:48.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/rss-button/
  md: https://developers.cloudflare.com/style-guide/components/rss-button/index.md
---

## Example

## Props

### `text`

**type:** `string`

**default:** `"Subscribe to RSS"`

The text to display in the button.

### `icon`

**type:** [`StarlightIcon`](https://starlight.astro.build/reference/icons/#all-icons)

**default:** `"rss"`

The icon to display next to the text. Uses Starlight's icon component.

### `changelog` or `href`

You must provide either `changelog` or `href`, but not both:

#### `changelog`

**type:** `string`

The name of the changelog to link to. This will be transformed into a lowercase, hyphen-separated string and used to construct the RSS feed URL in the format `/changelog/rss/{changelog}.xml`.

#### `href`

**type:** `string`

A custom URL to link to. Use this when you need to link to an RSS feed that doesn't follow the standard changelog URL pattern.
