---
title: WranglerCLI · Cloudflare Style Guide
description: The WranglerCLI component validates your Wrangler command & wraps
  it in the PackageManagers component.
lastUpdated: 2025-09-15T19:35:43.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/wrangler-cli/
  md: https://developers.cloudflare.com/style-guide/components/wrangler-cli/index.md
---

The `WranglerCLI` component validates your Wrangler command & wraps it in the [`PackageManagers`](https://developers.cloudflare.com/style-guide/components/package-managers/) component.

This is generated using the Wrangler version in the [`cloudflare-docs` repository](https://github.com/cloudflare/cloudflare-docs/blob/production/package.json).

## Import

```mdx
import { WranglerCLI } from "~/components";
```

## Usage

## Arguments

* `command` string required

  * The name of the command, i.e `d1 execute`.

* `positionals` string\[]

  * Any positional argument values, i.e `{["src/index.mjs]}"` for the optional `[SCRIPT]` positional argument on `deploy`.

* `flags` Record\<string, any>

  * Any named argument values, i.e `name: "my-worker"` for the optional `name` argument on `deploy`.

* `showArgs` boolean default (false)

  * Show the available arguments in a [`Details` component](https://developers.cloudflare.com/style-guide/components/details/) below the command.
